/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.binding;

import java.util.Locale;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.ConstraintDescriptor;
import org.mvcspec.ozark.cdi.OzarkInternal;

@ApplicationScoped
public class ConstraintViolationTranslator {
    private static final Logger log = Logger.getLogger(ConstraintViolationTranslator.class.getName());
    @Inject
    @OzarkInternal
    private ValidatorFactory validatorFactory;

    public String translate(ConstraintViolation<?> violation, Locale locale) {
        SimpleMessageInterpolatorContext context = new SimpleMessageInterpolatorContext(violation);
        MessageInterpolator interpolator = this.validatorFactory.getMessageInterpolator();
        return interpolator.interpolate(violation.getMessageTemplate(), (MessageInterpolator.Context)context, locale);
    }

    private static class SimpleMessageInterpolatorContext
    implements MessageInterpolator.Context {
        private final ConstraintViolation<?> violation;

        public SimpleMessageInterpolatorContext(ConstraintViolation<?> violation) {
            this.violation = violation;
        }

        public ConstraintDescriptor<?> getConstraintDescriptor() {
            return this.violation.getConstraintDescriptor();
        }

        public Object getValidatedValue() {
            return this.violation.getInvalidValue();
        }

        public <T> T unwrap(Class<T> type) {
            throw new UnsupportedOperationException();
        }
    }
}

