/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.binding.convert;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.mvcspec.ozark.binding.convert.MvcConverter;
import org.mvcspec.ozark.binding.convert.impl.BooleanConverter;
import org.mvcspec.ozark.binding.convert.impl.DoubleConverter;
import org.mvcspec.ozark.binding.convert.impl.FloatConverter;
import org.mvcspec.ozark.binding.convert.impl.IntegerConverter;
import org.mvcspec.ozark.binding.convert.impl.LongConverter;

@ApplicationScoped
public class ConverterRegistry {
    private final List<MvcConverter> converters = new ArrayList<MvcConverter>();

    @PostConstruct
    public void init() {
        this.register(new IntegerConverter());
        this.register(new LongConverter());
        this.register(new DoubleConverter());
        this.register(new FloatConverter());
        this.register(new BooleanConverter());
    }

    private void register(MvcConverter converter) {
        this.converters.add(converter);
    }

    <T> MvcConverter<T> lookup(Class<T> rawType, Annotation[] annotations) {
        return this.converters.stream().filter(converter -> converter.supports(rawType)).findFirst().orElse(null);
    }
}

