/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.binding.convert;

import java.util.Objects;
import java.util.Optional;

public class ConverterResult<T> {
    private T value;
    private String error;

    private ConverterResult(T value, String error) {
        this.value = value;
        this.error = error;
    }

    public static <T> ConverterResult<T> success(T value) {
        return new ConverterResult<T>(value, null);
    }

    public static <T> ConverterResult<T> failed(T value, String error) {
        return new ConverterResult<T>(value, Objects.requireNonNull(error, "Error must not be null"));
    }

    public Object getValue() {
        return this.value;
    }

    public Optional<String> getError() {
        return Optional.ofNullable(this.error);
    }
}

