/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.binding.convert;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.mvc.MvcContext;
import javax.mvc.binding.BindingError;
import javax.mvc.binding.MvcBinding;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.mvcspec.ozark.binding.BindingErrorImpl;
import org.mvcspec.ozark.binding.BindingResultImpl;
import org.mvcspec.ozark.binding.convert.ConverterRegistry;
import org.mvcspec.ozark.binding.convert.ConverterResult;
import org.mvcspec.ozark.binding.convert.MvcConverter;

public class MvcConverterProvider
implements ParamConverterProvider {
    @Inject
    private ConverterRegistry converterRegistry;
    @Inject
    private MvcContext mvcContext;
    @Inject
    private BindingResultImpl bindingResult;

    public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, final Annotation[] annotations) {
        MvcConverter<T> mvcConverter;
        MvcBinding mvcBinding = Stream.of(annotations != null ? annotations : new Annotation[]{}).filter(a -> a.annotationType().equals(MvcBinding.class)).findFirst().orElse(null);
        if (mvcBinding != null && (mvcConverter = this.converterRegistry.lookup(rawType, annotations)) != null) {
            return new ParamConverter<T>(){

                public T fromString(String value) {
                    ConverterResult result = mvcConverter.convert(value, rawType, MvcConverterProvider.this.mvcContext.getLocale());
                    result.getError().map(error -> new BindingErrorImpl((String)error, MvcConverterProvider.getParamName(annotations))).ifPresent(bindingError -> MvcConverterProvider.this.bindingResult.addBindingError((BindingError)bindingError));
                    return result.getValue();
                }

                public String toString(T value) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return null;
    }

    private static String getParamName(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation instanceof QueryParam) {
                return ((QueryParam)annotation).value();
            }
            if (annotation instanceof PathParam) {
                return ((PathParam)annotation).value();
            }
            if (annotation instanceof FormParam) {
                return ((FormParam)annotation).value();
            }
            if (annotation instanceof MatrixParam) {
                return ((MatrixParam)annotation).value();
            }
            if (!(annotation instanceof CookieParam)) continue;
            return ((CookieParam)annotation).value();
        }
        return null;
    }
}

