/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.binding.convert.impl;

import java.text.ParseException;
import java.util.Locale;
import org.mvcspec.ozark.binding.convert.ConverterResult;
import org.mvcspec.ozark.binding.convert.impl.NumberConverter;

public class FloatConverter
extends NumberConverter<Float> {
    @Override
    public boolean supports(Class<Float> rawType) {
        return Float.class.equals(rawType) || Float.TYPE.equals(rawType);
    }

    @Override
    public ConverterResult<Float> convert(String value, Class<Float> rawType, Locale locale) {
        try {
            return ConverterResult.success(Float.valueOf(this.parseNumber(value, locale).floatValue()));
        }
        catch (ParseException e) {
            Float defaultValue = Float.TYPE.equals(rawType) ? Float.valueOf(0.0f) : null;
            return ConverterResult.failed(defaultValue, e.getMessage());
        }
    }
}

