/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.binding.convert.impl;

import java.text.ParseException;
import java.util.Locale;
import org.mvcspec.ozark.binding.convert.ConverterResult;
import org.mvcspec.ozark.binding.convert.impl.NumberConverter;

public class IntegerConverter
extends NumberConverter<Integer> {
    @Override
    public boolean supports(Class<Integer> rawType) {
        return Integer.class.equals(rawType) || Integer.TYPE.equals(rawType);
    }

    @Override
    public ConverterResult<Integer> convert(String value, Class<Integer> rawType, Locale locale) {
        try {
            return ConverterResult.success(this.parseNumber(value, locale).intValue());
        }
        catch (ParseException e) {
            Integer defaultValue = Integer.TYPE.equals(rawType) ? Integer.valueOf(0) : null;
            return ConverterResult.failed(defaultValue, e.getMessage());
        }
    }
}

