/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.binding.convert.impl;

import java.text.ParseException;
import java.util.Locale;
import org.mvcspec.ozark.binding.convert.ConverterResult;
import org.mvcspec.ozark.binding.convert.impl.NumberConverter;

public class LongConverter
extends NumberConverter<Long> {
    @Override
    public boolean supports(Class<Long> rawType) {
        return Long.class.equals(rawType) || Long.TYPE.equals(rawType);
    }

    @Override
    public ConverterResult<Long> convert(String value, Class<Long> rawType, Locale locale) {
        try {
            return ConverterResult.success(this.parseNumber(value, locale).longValue());
        }
        catch (ParseException e) {
            Long defaultValue = Long.TYPE.equals(rawType) ? Long.valueOf(0L) : null;
            return ConverterResult.failed(defaultValue, e.getMessage());
        }
    }
}

