/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.binding.convert.impl;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import org.mvcspec.ozark.binding.convert.MvcConverter;

abstract class NumberConverter<T extends Number>
implements MvcConverter<T> {
    NumberConverter() {
    }

    Number parseNumber(String value, Locale locale) throws ParseException {
        if (value != null && !value.trim().isEmpty()) {
            ParsePosition parsePosition = new ParsePosition(0);
            NumberFormat numberFormat = NumberFormat.getInstance(locale);
            Number result = numberFormat.parse(value.trim(), parsePosition);
            if (value.trim().length() != parsePosition.getIndex()) {
                throw new ParseException("Not a valid number: " + value.trim(), parsePosition.getIndex());
            }
            return result;
        }
        return null;
    }
}

