/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.binding.validate;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.validation.ConstraintViolation;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

public class ConstraintViolationMetadata {
    private final ConstraintViolation<?> violation;
    private final Annotation[] annotations;

    public ConstraintViolationMetadata(ConstraintViolation<?> violation, Annotation[] annotations) {
        this.violation = Objects.requireNonNull(violation, "violations");
        this.annotations = Objects.requireNonNull(annotations, "annotations");
    }

    public Optional<Annotation> getAnnotation(Class<Annotation> type) {
        return Arrays.stream(this.annotations).filter(a -> a.annotationType().equals(type)).findFirst();
    }

    public boolean hasAnnotation(Class<? extends Annotation> type) {
        return Arrays.stream(this.annotations).anyMatch(a -> a.annotationType().equals(type));
    }

    public Optional<String> getParamName() {
        for (Annotation annotation : this.annotations) {
            if (annotation instanceof QueryParam) {
                return Optional.of(((QueryParam)annotation).value());
            }
            if (annotation instanceof PathParam) {
                return Optional.of(((PathParam)annotation).value());
            }
            if (annotation instanceof FormParam) {
                return Optional.of(((FormParam)annotation).value());
            }
            if (annotation instanceof MatrixParam) {
                return Optional.of(((MatrixParam)annotation).value());
            }
            if (!(annotation instanceof CookieParam)) continue;
            return Optional.of(((CookieParam)annotation).value());
        }
        return Optional.empty();
    }
}

