/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.binding.validate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.Path;
import org.mvcspec.ozark.binding.validate.ConstraintViolationMetadata;

public class ConstraintViolations {
    private static final Logger log = Logger.getLogger(ConstraintViolations.class.getName());

    private ConstraintViolations() {
    }

    public static ConstraintViolationMetadata getMetadata(ConstraintViolation<?> violation) {
        Annotation[] annotations = ConstraintViolations.getAnnotations(violation);
        return new ConstraintViolationMetadata(violation, annotations);
    }

    private static Annotation[] getAnnotations(ConstraintViolation<?> violation) {
        ArrayList<Path.Node> nodes = new ArrayList<Path.Node>();
        for (Path.Node node : violation.getPropertyPath()) {
            nodes.add(node);
        }
        Path.Node lastNode = (Path.Node)nodes.get(nodes.size() - 1);
        if (lastNode.getKind() == ElementKind.PROPERTY) {
            Path.PropertyNode propertyNode = (Path.PropertyNode)lastNode.as(Path.PropertyNode.class);
            return ConstraintViolations.getPropertyAnnotations(violation, propertyNode);
        }
        if (lastNode.getKind() == ElementKind.PARAMETER && nodes.size() == 2) {
            Path.MethodNode methodNode = (Path.MethodNode)((Path.Node)nodes.get(0)).as(Path.MethodNode.class);
            Path.ParameterNode parameterNode = (Path.ParameterNode)((Path.Node)nodes.get(1)).as(Path.ParameterNode.class);
            return ConstraintViolations.getParameterAnnotations(violation, methodNode, parameterNode);
        }
        log.warning("Could not read annotations for path: " + violation.getPropertyPath().toString());
        return new Annotation[0];
    }

    private static Annotation[] getPropertyAnnotations(ConstraintViolation<?> violation, Path.PropertyNode node) {
        try {
            Class<?> leafBeanClass = violation.getLeafBean().getClass();
            Field field = leafBeanClass.getDeclaredField(node.getName());
            return field.getAnnotations();
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Annotation[] getParameterAnnotations(ConstraintViolation<?> violation, Path.MethodNode methodNode, Path.ParameterNode parameterNode) {
        try {
            String methodName = methodNode.getName();
            int paramCount = methodNode.getParameterTypes().size();
            Class[] paramTypes = methodNode.getParameterTypes().toArray(new Class[paramCount]);
            Class<?> rootBeanClass = violation.getRootBean().getClass();
            Method method = rootBeanClass.getMethod(methodName, paramTypes);
            int parameterIndex = parameterNode.getParameterIndex();
            return method.getParameterAnnotations()[parameterIndex];
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }
}

