/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.binding.validate;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.mvc.MvcContext;
import javax.mvc.binding.MvcBinding;
import javax.mvc.binding.ValidationError;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import org.mvcspec.ozark.binding.BindingResultImpl;
import org.mvcspec.ozark.binding.ConstraintViolationTranslator;
import org.mvcspec.ozark.binding.ValidationErrorImpl;
import org.mvcspec.ozark.binding.validate.ConstraintViolationMetadata;
import org.mvcspec.ozark.binding.validate.ConstraintViolations;
import org.mvcspec.ozark.binding.validate.ValidationInterceptorBinding;
import org.mvcspec.ozark.cdi.OzarkInternal;

@Interceptor
@ValidationInterceptorBinding
@Priority(value=1000)
public class ValidationInterceptor
implements Serializable {
    private static final long serialVersionUID = -5804986456381504613L;
    private static final Logger log = Logger.getLogger(ValidationInterceptor.class.getName());
    @Inject
    @OzarkInternal
    private ValidatorFactory validatorFactory;
    @Inject
    private ConstraintViolationTranslator violationTranslator;
    @Inject
    private MvcContext mvcContext;
    @Inject
    private BindingResultImpl bindingResult;

    @AroundInvoke
    public Object validateMethodInvocation(InvocationContext ctx) throws Exception {
        Object resource = ctx.getTarget();
        Method method = ctx.getMethod();
        log.log(Level.FINE, "Starting validation for controller method: {0}#{1}", new Object[]{resource.getClass().getName(), method.getName()});
        Validator validator = this.validatorFactory.getValidator();
        ExecutableValidator executableValidator = validator.forExecutables();
        this.processViolations(ctx, validator.validate(resource, new Class[0]));
        this.processViolations(ctx, executableValidator.validateParameters(resource, method, ctx.getParameters(), new Class[0]));
        Object result = ctx.proceed();
        this.processViolations(ctx, executableValidator.validateReturnValue(resource, method, result, new Class[0]));
        return result;
    }

    private void processViolations(InvocationContext ctx, Set<ConstraintViolation<Object>> violations) {
        if (violations.isEmpty()) {
            return;
        }
        log.log(Level.FINE, "Validation found {} constraint violations...", violations.size());
        LinkedHashSet<ValidationError> validationErrors = new LinkedHashSet<ValidationError>();
        for (ConstraintViolation<Object> violation : violations) {
            boolean hasBindingError;
            ConstraintViolationMetadata metadata = ConstraintViolations.getMetadata(violation);
            if (!metadata.hasAnnotation(MvcBinding.class)) continue;
            String paramName = metadata.getParamName().orElse(null);
            if (paramName == null) {
                log.log(Level.WARNING, "Cannot resolve paramName for violation: {0}", violation);
            }
            if (hasBindingError = paramName != null && !paramName.isEmpty() && this.bindingResult.getBindingError(paramName) != null) continue;
            String message = this.violationTranslator.translate(violation, this.mvcContext.getLocale());
            validationErrors.add(new ValidationErrorImpl(violation, paramName, message));
        }
        if (!validationErrors.isEmpty()) {
            log.log(Level.FINE, "Adding {0} validation errors to binding result", validationErrors.size());
            this.bindingResult.addValidationErrors(validationErrors);
        }
    }
}

