/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.bootstrap;

import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.FeatureContext;
import org.mvcspec.ozark.bootstrap.ConfigProvider;
import org.mvcspec.ozark.core.ViewResponseFilter;

public final class OzarkInitializer {
    private static final Logger log = Logger.getLogger(OzarkInitializer.class.getName());

    private OzarkInitializer() {
    }

    public static void initialize(FeatureContext context, ServletContext servletContext) {
        Configuration config = context.getConfiguration();
        if (!OzarkInitializer.isAlreadyInitialized(config) && OzarkInitializer.isMvcApplication(servletContext)) {
            log.info("Initializing Ozark...");
            for (ConfigProvider provider : ServiceLoader.load(ConfigProvider.class)) {
                log.log(Level.FINE, "Executing: {0}", provider.getClass().getName());
                provider.configure(context);
            }
        }
    }

    private static boolean isAlreadyInitialized(Configuration config) {
        return config.isRegistered(ViewResponseFilter.class);
    }

    private static boolean isMvcApplication(ServletContext servletContext) {
        Object controllersFound = servletContext.getAttribute("ozark.controllers-found");
        boolean enableOzark = !Boolean.FALSE.equals(controllersFound);
        log.log(Level.FINE, "Is Ozark application detected: {0}", enableOzark);
        return enableOzark;
    }
}

