/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.cdi;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Context;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.mvc.annotation.Controller;
import javax.mvc.annotation.RedirectScoped;
import javax.mvc.event.MvcEvent;
import org.mvcspec.ozark.MvcContextImpl;
import org.mvcspec.ozark.OzarkConfig;
import org.mvcspec.ozark.binding.BeanValidationProducer;
import org.mvcspec.ozark.binding.BindingResultManager;
import org.mvcspec.ozark.binding.ConstraintViolationTranslator;
import org.mvcspec.ozark.binding.convert.ConverterRegistry;
import org.mvcspec.ozark.binding.convert.MvcConverterProvider;
import org.mvcspec.ozark.binding.validate.ValidationInterceptor;
import org.mvcspec.ozark.cdi.RedirectScopeContext;
import org.mvcspec.ozark.cdi.RedirectScopeManager;
import org.mvcspec.ozark.cdi.types.AnnotatedTypeProcessor;
import org.mvcspec.ozark.core.Messages;
import org.mvcspec.ozark.core.ModelsImpl;
import org.mvcspec.ozark.core.ViewRequestFilter;
import org.mvcspec.ozark.core.ViewResponseFilter;
import org.mvcspec.ozark.core.ViewableWriter;
import org.mvcspec.ozark.engine.FaceletsViewEngine;
import org.mvcspec.ozark.engine.JspViewEngine;
import org.mvcspec.ozark.engine.ViewEngineFinder;
import org.mvcspec.ozark.event.AfterControllerEventImpl;
import org.mvcspec.ozark.event.AfterProcessViewEventImpl;
import org.mvcspec.ozark.event.BeforeControllerEventImpl;
import org.mvcspec.ozark.event.BeforeProcessViewEventImpl;
import org.mvcspec.ozark.event.ControllerRedirectEventImpl;
import org.mvcspec.ozark.event.MvcEventImpl;
import org.mvcspec.ozark.jaxrs.JaxRsContextFilter;
import org.mvcspec.ozark.jaxrs.JaxRsContextProducer;
import org.mvcspec.ozark.locale.DefaultLocaleResolver;
import org.mvcspec.ozark.locale.LocaleRequestFilter;
import org.mvcspec.ozark.locale.LocaleResolverChain;
import org.mvcspec.ozark.security.CsrfImpl;
import org.mvcspec.ozark.security.CsrfProtectFilter;
import org.mvcspec.ozark.security.CsrfTokenManager;
import org.mvcspec.ozark.security.CsrfValidateInterceptor;
import org.mvcspec.ozark.security.EncodersImpl;
import org.mvcspec.ozark.uri.ApplicationUris;
import org.mvcspec.ozark.uri.UriTemplateParser;
import org.mvcspec.ozark.util.CdiUtils;

public class OzarkCdiExtension
implements Extension {
    private static final Logger log = Logger.getLogger(OzarkCdiExtension.class.getName());
    private static Set<Class<? extends MvcEvent>> observedEvents;
    private final AnnotatedTypeProcessor annotatedTypeProcessor = new AnnotatedTypeProcessor();

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        log.fine("Observed BeforeBeanDiscovery event, registering scopes and beans...");
        event.addScope(RedirectScoped.class, true, true);
        CdiUtils.addAnnotatedTypes(event, beanManager, MvcContextImpl.class, OzarkConfig.class, BeanValidationProducer.class, BindingResultManager.class, ConstraintViolationTranslator.class, ConverterRegistry.class, MvcConverterProvider.class, Messages.class, ModelsImpl.class, ViewableWriter.class, ViewRequestFilter.class, ViewResponseFilter.class, FaceletsViewEngine.class, JspViewEngine.class, ViewEngineFinder.class, CsrfImpl.class, CsrfProtectFilter.class, CsrfValidateInterceptor.class, CsrfTokenManager.class, EncodersImpl.class, CdiUtils.class, RedirectScopeManager.class, ValidationInterceptor.class, AfterControllerEventImpl.class, AfterProcessViewEventImpl.class, BeforeControllerEventImpl.class, BeforeProcessViewEventImpl.class, ControllerRedirectEventImpl.class, MvcEventImpl.class, LocaleRequestFilter.class, LocaleResolverChain.class, DefaultLocaleResolver.class, JaxRsContextFilter.class, JaxRsContextProducer.class, ApplicationUris.class, UriTemplateParser.class);
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        event.addContext((Context)new RedirectScopeContext());
    }

    public <T> void processAnnotatedType(@Observes @WithAnnotations(value={Controller.class}) ProcessAnnotatedType<T> pat) {
        AnnotatedType replacement = this.annotatedTypeProcessor.getReplacement(pat.getAnnotatedType());
        if (replacement != null) {
            log.log(Level.FINE, "Replacing AnnotatedType of class: {0}", replacement.getJavaClass().getName());
            pat.setAnnotatedType(replacement);
        }
    }

    public <T, X> void processObserverMethod(@Observes ProcessObserverMethod<T, X> pom, BeanManager beanManager) {
        Class clazz;
        Type type = pom.getObserverMethod().getObservedType();
        if (type instanceof Class && MvcEvent.class.isAssignableFrom(clazz = (Class)type)) {
            OzarkCdiExtension.addObservedEvent((Class)type);
        }
    }

    public static synchronized void addObservedEvent(Class<? extends MvcEvent> eventType) {
        if (observedEvents == null) {
            observedEvents = new HashSet<Class<? extends MvcEvent>>();
        }
        observedEvents.add(eventType);
    }

    public static synchronized boolean isEventObserved(Class<? extends MvcEvent> eventType) {
        return observedEvents == null ? false : observedEvents.contains(eventType);
    }
}

