/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.cdi;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.inject.Inject;
import javax.mvc.MvcContext;
import javax.mvc.event.AfterProcessViewEvent;
import javax.mvc.event.BeforeControllerEvent;
import javax.mvc.event.ControllerRedirectEvent;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.UriBuilder;
import org.mvcspec.ozark.event.ControllerRedirectEventImpl;
import org.mvcspec.ozark.jaxrs.JaxRsContext;
import org.mvcspec.ozark.util.CdiUtils;
import org.mvcspec.ozark.util.PropertyUtils;

@ApplicationScoped
public class RedirectScopeManager {
    private static final String PREFIX = "org.mvcspec.ozark.redirect.";
    private static final String SCOPE_ID = "org.mvcspec.ozark.redirect.ScopeId";
    private static final String INSTANCE = "Instance-";
    private static final String CREATIONAL = "Creational-";
    private static final String COOKIE_NAME = "org.mvcspec.ozark.redirect.Cookie";
    @Inject
    private HttpServletRequest request;
    @Inject
    @JaxRsContext
    private HttpServletResponse response;
    @Inject
    @JaxRsContext
    private Configuration config;
    @Inject
    private MvcContext mvc;

    @PostConstruct
    public void init() {
        if (this.config == null || this.response == null) {
            throw new IllegalStateException("It looks like @Context injection doesn't work for CDI beans. Please make sure you are using a recent version of Jersey.");
        }
    }

    public void destroy(Contextual contextual) {
        String scopeId = (String)this.request.getAttribute(SCOPE_ID);
        if (null != scopeId) {
            HttpSession session = this.request.getSession();
            if (!(contextual instanceof PassivationCapable)) {
                throw new RuntimeException("Unexpected type for contextual");
            }
            PassivationCapable pc = (PassivationCapable)contextual;
            String sessionKey = "org.mvcspec.ozark.redirect.ScopeId-" + scopeId;
            Map scopeMap = (Map)session.getAttribute(sessionKey);
            if (null != scopeMap) {
                Object instance = scopeMap.get(INSTANCE + pc.getId());
                CreationalContext creational = (CreationalContext)scopeMap.get(CREATIONAL + pc.getId());
                if (null != instance && null != creational) {
                    contextual.destroy(instance, creational);
                    creational.release();
                }
            }
        }
    }

    public <T> T get(Contextual<T> contextual) {
        T result = null;
        String scopeId = (String)this.request.getAttribute(SCOPE_ID);
        if (null != scopeId) {
            HttpSession session = this.request.getSession();
            if (!(contextual instanceof PassivationCapable)) {
                throw new RuntimeException("Unexpected type for contextual");
            }
            PassivationCapable pc = (PassivationCapable)contextual;
            String sessionKey = "org.mvcspec.ozark.redirect.ScopeId-" + scopeId;
            Map scopeMap = (Map)session.getAttribute(sessionKey);
            if (null != scopeMap) {
                result = (T)scopeMap.get(INSTANCE + pc.getId());
            } else {
                this.request.setAttribute(SCOPE_ID, null);
            }
        }
        return result;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creational) {
        Object result = this.get(contextual);
        if (result == null) {
            String scopeId = (String)this.request.getAttribute(SCOPE_ID);
            if (null == scopeId) {
                scopeId = this.generateScopeId();
            }
            HttpSession session = this.request.getSession();
            result = contextual.create(creational);
            if (!(contextual instanceof PassivationCapable)) {
                throw new RuntimeException("Unexpected type for contextual");
            }
            PassivationCapable pc = (PassivationCapable)contextual;
            String sessionKey = "org.mvcspec.ozark.redirect.ScopeId-" + scopeId;
            Map scopeMap = (Map)session.getAttribute(sessionKey);
            if (null != scopeMap) {
                session.setAttribute(sessionKey, (Object)scopeMap);
                scopeMap.put(INSTANCE + pc.getId(), result);
                scopeMap.put(CREATIONAL + pc.getId(), creational);
            }
        }
        return result;
    }

    public void beforeProcessControllerEvent(@Observes BeforeControllerEvent event) {
        if (this.usingCookies()) {
            Cookie[] cookies = this.request.getCookies();
            if (null != cookies) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals(COOKIE_NAME)) continue;
                    this.request.setAttribute(SCOPE_ID, (Object)cookie.getValue());
                    return;
                }
            }
        } else {
            String scopeId = (String)event.getUriInfo().getQueryParameters().getFirst((Object)SCOPE_ID);
            if (scopeId != null) {
                this.request.setAttribute(SCOPE_ID, (Object)scopeId);
            }
        }
    }

    public void afterProcessViewEvent(@Observes AfterProcessViewEvent event) {
        if (this.request.getAttribute(SCOPE_ID) != null) {
            String sessionKey;
            String scopeId = (String)this.request.getAttribute(SCOPE_ID);
            HttpSession session = this.request.getSession();
            Map scopeMap = (Map)session.getAttribute(sessionKey = "org.mvcspec.ozark.redirect.ScopeId-" + scopeId);
            if (null != scopeMap) {
                scopeMap.entrySet().stream().forEach(entrySet -> {
                    String key = (String)entrySet.getKey();
                    Object value = entrySet.getValue();
                    if (key.startsWith(INSTANCE)) {
                        BeanManager beanManager = CdiUtils.getApplicationBeanManager();
                        Bean bean = beanManager.resolve(beanManager.getBeans(value.getClass(), new Annotation[0]));
                        this.destroy((Contextual)bean);
                    }
                });
                scopeMap.clear();
                session.removeAttribute(sessionKey);
            }
        }
    }

    public void controllerRedirectEvent(@Observes ControllerRedirectEvent event) {
        if (this.request.getAttribute(SCOPE_ID) != null) {
            if (this.usingCookies()) {
                Cookie cookie = new Cookie(COOKIE_NAME, this.request.getAttribute(SCOPE_ID).toString());
                cookie.setPath(this.mvc.getContextPath());
                cookie.setMaxAge(600);
                cookie.setHttpOnly(true);
                this.response.addCookie(cookie);
            } else {
                ContainerResponseContext crc = ((ControllerRedirectEventImpl)event).getContainerResponseContext();
                UriBuilder builder = UriBuilder.fromUri((String)((String)crc.getStringHeaders().getFirst((Object)"Location")));
                builder.queryParam(SCOPE_ID, new Object[]{this.request.getAttribute(SCOPE_ID).toString()});
                crc.getHeaders().putSingle((Object)"Location", (Object)builder.build(new Object[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateScopeId() {
        HttpSession session = this.request.getSession();
        String scopeId = UUID.randomUUID().toString();
        String sessionKey = "org.mvcspec.ozark.redirect.ScopeId-" + scopeId;
        RedirectScopeManager redirectScopeManager = this;
        synchronized (redirectScopeManager) {
            while (session.getAttribute(sessionKey) != null) {
                scopeId = UUID.randomUUID().toString();
                sessionKey = "org.mvcspec.ozark.redirect.ScopeId-" + scopeId;
            }
            session.setAttribute(sessionKey, new HashMap());
            this.request.setAttribute(SCOPE_ID, (Object)scopeId);
        }
        return scopeId;
    }

    private boolean usingCookies() {
        return PropertyUtils.getProperty(this.config, "org.mvcspec.ozark.redirectScopeCookies", false);
    }
}

