/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.cdi.types;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.mvc.annotation.Controller;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import org.mvcspec.ozark.binding.validate.ValidationInterceptorBinding;
import org.mvcspec.ozark.cdi.types.AnnotatedMethodWrapper;
import org.mvcspec.ozark.cdi.types.AnnotatedTypeWrapper;

public class AnnotatedTypeProcessor {
    private static final Logger log = Logger.getLogger(AnnotatedTypeProcessor.class.getName());

    public <T> AnnotatedType<T> getReplacement(AnnotatedType<T> originalType) {
        boolean modified = false;
        LinkedHashSet methods = new LinkedHashSet();
        for (AnnotatedMethod originalMethod : originalType.getMethods()) {
            AnnotatedMethod<T> replacement = this.getReplacement(originalType, originalMethod);
            if (replacement != null) {
                methods.add(replacement);
                modified = true;
                continue;
            }
            methods.add(originalMethod);
        }
        if (modified) {
            return new AnnotatedTypeWrapper(originalType, methods);
        }
        return null;
    }

    private <T> AnnotatedMethod<? super T> getReplacement(AnnotatedType<T> type, AnnotatedMethod<? super T> method) {
        boolean hasControllerAnnotation;
        boolean isResourceMethod = method.getAnnotation(GET.class) != null || method.getAnnotation(POST.class) != null || method.getAnnotation(PUT.class) != null || method.getAnnotation(HEAD.class) != null || method.getAnnotation(DELETE.class) != null;
        boolean bl = hasControllerAnnotation = method.getAnnotation(Controller.class) != null || type.getAnnotation(Controller.class) != null;
        if (isResourceMethod && hasControllerAnnotation) {
            log.log(Level.FINE, "Found controller method: {0}#{1}", new Object[]{type.getJavaClass().getName(), method.getJavaMember().getName()});
            return new AnnotatedMethodWrapper<T>(method, Collections.singleton(() -> ValidationInterceptorBinding.class));
        }
        return null;
    }
}

