/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.core;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.mvc.annotation.Controller;
import javax.mvc.annotation.View;
import javax.mvc.event.AfterControllerEvent;
import javax.mvc.event.ControllerRedirectEvent;
import javax.mvc.event.MvcEvent;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Produces;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.mvcspec.ozark.cdi.OzarkCdiExtension;
import org.mvcspec.ozark.core.Messages;
import org.mvcspec.ozark.engine.Viewable;
import org.mvcspec.ozark.event.AfterControllerEventImpl;
import org.mvcspec.ozark.event.ControllerRedirectEventImpl;
import org.mvcspec.ozark.util.AnnotationUtils;
import org.mvcspec.ozark.util.PathUtils;

@Controller
@Priority(value=4000)
public class ViewResponseFilter
implements ContainerResponseFilter {
    private static final String REDIRECT = "redirect:";
    @Context
    private UriInfo uriInfo;
    @Context
    private ResourceInfo resourceInfo;
    @Context
    private HttpServletRequest request;
    @Inject
    private Event<MvcEvent> dispatcher;
    @Inject
    private Messages messages;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        int status;
        String view;
        Class<?> entityType;
        if (OzarkCdiExtension.isEventObserved(AfterControllerEvent.class)) {
            AfterControllerEventImpl event = new AfterControllerEventImpl();
            event.setUriInfo(this.uriInfo);
            event.setResourceInfo(this.resourceInfo);
            event.setContainerRequestContext(requestContext);
            event.setContainerResponseContext(responseContext);
            this.dispatcher.fire((Object)event);
        }
        Method method = this.resourceInfo.getResourceMethod();
        Class<?> returnType = method.getReturnType();
        Object entity = responseContext.getEntity();
        Class<?> clazz = entityType = entity != null ? entity.getClass() : null;
        if (entityType == null) {
            View an = AnnotationUtils.getAnnotation(method, View.class);
            if (an == null) {
                an = AnnotationUtils.getAnnotation(this.resourceInfo.getResourceClass(), View.class);
            }
            if (an != null) {
                MediaType contentType = ViewResponseFilter.selectVariant(requestContext.getRequest(), this.resourceInfo);
                if (contentType == null) {
                    contentType = MediaType.TEXT_HTML_TYPE;
                }
                responseContext.setEntity((Object)new Viewable(an.value()), null, contentType);
                responseContext.setStatusInfo((Response.StatusType)(responseContext.getStatusInfo() == Response.Status.NO_CONTENT ? Response.Status.OK : responseContext.getStatusInfo()));
            } else if (returnType == Void.class) {
                throw new ServerErrorException(this.messages.get("VoidControllerNoView", this.resourceInfo.getResourceMethod()), Response.Status.INTERNAL_SERVER_ERROR);
            }
        } else if (entityType != Viewable.class) {
            view = entity.toString();
            if (view == null) {
                throw new ServerErrorException(this.messages.get("EntityToStringNull", this.resourceInfo.getResourceMethod()), Response.Status.INTERNAL_SERVER_ERROR);
            }
            responseContext.setEntity((Object)new Viewable(view), null, responseContext.getMediaType());
        }
        if ((entity = responseContext.getEntity()) != null) {
            view = ((Viewable)entity).getView();
            String uri = this.uriInfo.getBaseUri() + PathUtils.noStartingSlash(PathUtils.noPrefix(view, REDIRECT));
            if (view.startsWith(REDIRECT)) {
                responseContext.setStatusInfo((Response.StatusType)Response.Status.SEE_OTHER);
                responseContext.getHeaders().putSingle((Object)"Location", (Object)uri);
                responseContext.setEntity(null);
            }
        }
        if (OzarkCdiExtension.isEventObserved(ControllerRedirectEvent.class) && ((status = responseContext.getStatus()) == Response.Status.SEE_OTHER.getStatusCode() || status == Response.Status.MOVED_PERMANENTLY.getStatusCode() || status == Response.Status.FOUND.getStatusCode() || status == Response.Status.TEMPORARY_REDIRECT.getStatusCode())) {
            ControllerRedirectEventImpl event = new ControllerRedirectEventImpl();
            event.setUriInfo(this.uriInfo);
            event.setResourceInfo(this.resourceInfo);
            event.setLocation(URI.create(responseContext.getHeaderString("Location")));
            event.setContainerRequestContext(requestContext);
            event.setContainerResponseContext(responseContext);
            this.dispatcher.fire((Object)event);
        }
    }

    private static MediaType selectVariant(Request request, ResourceInfo resourceInfo) {
        List variants;
        Variant variant;
        Produces produces = resourceInfo.getResourceMethod().getAnnotation(Produces.class);
        if (produces == null) {
            produces = AnnotationUtils.getAnnotation(resourceInfo.getResourceClass(), Produces.class);
        }
        if (produces != null && (variant = request.selectVariant(variants = Arrays.stream(produces.value()).map(mt -> (Variant)Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.valueOf((String)mt)}).build().get(0)).collect(Collectors.toList()))) != null) {
            return variant.getMediaType();
        }
        return null;
    }
}

