/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.mvc.Models;
import javax.mvc.MvcContext;
import javax.mvc.engine.ViewEngine;
import javax.mvc.engine.ViewEngineContext;
import javax.mvc.engine.ViewEngineException;
import javax.mvc.event.AfterProcessViewEvent;
import javax.mvc.event.BeforeProcessViewEvent;
import javax.mvc.event.MvcEvent;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.ws.rs.Produces;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import org.mvcspec.ozark.cdi.OzarkCdiExtension;
import org.mvcspec.ozark.core.Messages;
import org.mvcspec.ozark.engine.ViewEngineContextImpl;
import org.mvcspec.ozark.engine.ViewEngineFinder;
import org.mvcspec.ozark.engine.Viewable;
import org.mvcspec.ozark.event.AfterProcessViewEventImpl;
import org.mvcspec.ozark.event.BeforeProcessViewEventImpl;
import org.mvcspec.ozark.event.MvcEventImpl;
import org.mvcspec.ozark.util.PathUtils;

@Produces(value={"*/*"})
public class ViewableWriter
implements MessageBodyWriter<Viewable> {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final Charset UTF8 = Charset.forName("UTF-8");
    @Inject
    private Instance<Models> modelsInstance;
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;
    @Context
    private UriInfo uriInfo;
    @Context
    private ResourceInfo resourceInfo;
    @Inject
    private ViewEngineFinder engineFinder;
    @Context
    private Configuration config;
    @Inject
    private Messages messages;
    @Inject
    private Event<MvcEvent> dispatcher;
    @Inject
    private MvcContext mvc;

    public boolean isWriteable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return aClass == Viewable.class;
    }

    public long getSize(Viewable viewable, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Viewable viewable, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, final OutputStream out) throws IOException, WebApplicationException {
        ViewEngine engine = this.engineFinder.find(viewable);
        if (engine == null) {
            RequestDispatcher requestDispatcher = this.request.getServletContext().getRequestDispatcher(PathUtils.ensureStartingSlash(viewable.getView()));
            if (requestDispatcher != null) {
                try {
                    requestDispatcher.forward((ServletRequest)new HttpServletRequestWrapper(this.request), (ServletResponse)new HttpServletResponseWrapper(this.response));
                }
                catch (ServletException ex) {
                    throw new ServerErrorException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
                }
            } else {
                throw new ServerErrorException(this.messages.get("NoViewEngine", viewable), Response.Status.INTERNAL_SERVER_ERROR);
            }
            return;
        }
        final ServletOutputStream responseStream = new ServletOutputStream(){

            public void write(int b) throws IOException {
                out.write(b);
            }

            public boolean isReady() {
                return false;
            }

            public void setWriteListener(WriteListener writeListener) {
                throw new UnsupportedOperationException("Not supported");
            }
        };
        final PrintWriter responseWriter = new PrintWriter(new OutputStreamWriter((OutputStream)responseStream, this.getCharset(headers)));
        HttpServletResponseWrapper responseWrapper = new HttpServletResponseWrapper(this.response){

            public ServletOutputStream getOutputStream() throws IOException {
                return responseStream;
            }

            public PrintWriter getWriter() throws IOException {
                return responseWriter;
            }
        };
        try {
            MvcEventImpl event;
            Models models = viewable.getModels();
            if (models == null) {
                models = (Models)this.modelsInstance.get();
            }
            models.put((Object)"mvc", (Object)this.mvc);
            if (OzarkCdiExtension.isEventObserved(BeforeProcessViewEvent.class)) {
                event = new BeforeProcessViewEventImpl();
                ((BeforeProcessViewEventImpl)event).setEngine(engine.getClass());
                ((BeforeProcessViewEventImpl)event).setView(viewable.getView());
                this.dispatcher.fire((Object)event);
            }
            engine.processView((ViewEngineContext)new ViewEngineContextImpl(viewable.getView(), models, this.request, (HttpServletResponse)responseWrapper, this.uriInfo, this.resourceInfo, this.config));
            if (OzarkCdiExtension.isEventObserved(AfterProcessViewEvent.class)) {
                event = new AfterProcessViewEventImpl();
                ((AfterProcessViewEventImpl)event).setEngine(engine.getClass());
                ((AfterProcessViewEventImpl)event).setView(viewable.getView());
                this.dispatcher.fire((Object)event);
            }
        }
        catch (ViewEngineException e) {
            throw new ServerErrorException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        finally {
            responseWriter.flush();
        }
    }

    private Charset getCharset(MultivaluedMap<String, Object> headers) {
        MediaType mt = (MediaType)((List)headers.get((Object)CONTENT_TYPE)).get(0);
        String charset = (String)mt.getParameters().get("charset");
        return charset != null ? Charset.forName(charset) : UTF8;
    }
}

