/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.engine;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.mvc.Models;
import javax.mvc.engine.ViewEngineContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.mvcspec.ozark.engine.ViewEngineBase;

public abstract class ServletViewEngine
extends ViewEngineBase {
    @Inject
    protected ServletContext servletContext;

    protected void forwardRequest(final ViewEngineContext context, String ... extensions) throws ServletException, IOException {
        RequestDispatcher rd = null;
        Object request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        Models models = context.getModels();
        for (String name : models) {
            request.setAttribute(name, models.get((Object)name));
        }
        for (Map.Entry e : this.servletContext.getServletRegistrations().entrySet()) {
            Collection mappings = ((ServletRegistration)e.getValue()).getMappings();
            if (!mappings.containsAll(Arrays.asList(extensions))) continue;
            rd = this.servletContext.getNamedDispatcher((String)e.getKey());
            request = new HttpServletRequestWrapper(context.getRequest()){

                public String getRequestURI() {
                    return ServletViewEngine.this.resolveView(context);
                }

                public String getServletPath() {
                    return ServletViewEngine.this.resolveView(context);
                }

                public String getPathInfo() {
                    return null;
                }

                public StringBuffer getRequestURL() {
                    return new StringBuffer(this.getRequestURI());
                }
            };
            break;
        }
        if (rd == null) {
            rd = this.servletContext.getRequestDispatcher(this.resolveView(context));
        }
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }
}

