/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.engine;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.mvc.engine.ViewEngine;
import org.mvcspec.ozark.engine.Viewable;
import org.mvcspec.ozark.util.AnnotationUtils;
import org.mvcspec.ozark.util.CdiUtils;

@ApplicationScoped
public class ViewEngineFinder {
    @Inject
    private CdiUtils cdiUtils;
    private Map<String, ViewEngine> cache = new HashMap<String, ViewEngine>();

    public ViewEngine find(Viewable viewable) {
        Optional<Object> engine;
        String view = viewable.getView();
        Class<? extends ViewEngine> engineClass = viewable.getViewEngine();
        if (engineClass != null) {
            engine = Optional.of(this.cdiUtils.newBean(engineClass));
        } else {
            List<ViewEngine> engines;
            Set candidates;
            engine = Optional.ofNullable(this.cache.get(view));
            if (!engine.isPresent() && (engine = (candidates = (engines = CdiUtils.getApplicationBeans(ViewEngine.class, new Annotation[0])).stream().filter(e -> e.supports(view)).collect(Collectors.toSet())).stream().max((e1, e2) -> {
                Priority p1 = AnnotationUtils.getAnnotation(e1.getClass(), Priority.class);
                int v1 = p1 != null ? p1.value() : 1000;
                Priority p2 = AnnotationUtils.getAnnotation(e2.getClass(), Priority.class);
                int v2 = p2 != null ? p2.value() : 1000;
                return v1 - v2;
            })).isPresent()) {
                this.cache.put(view, (ViewEngine)engine.get());
            }
        }
        return engine.isPresent() ? engine.get() : null;
    }
}

