/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.security;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mvcspec.ozark.security.CsrfToken;
import org.mvcspec.ozark.security.CsrfTokenStrategy;

public class CookieCsrfTokenStrategy
implements CsrfTokenStrategy {
    private final String headerName;
    private final String paramName;
    private final String cookieName;
    private final int maxAge;
    private final boolean httpOnly;

    private CookieCsrfTokenStrategy(Builder builder) {
        this.headerName = builder.headerName;
        this.paramName = builder.paramName;
        this.cookieName = builder.cookieName;
        this.maxAge = builder.maxAge;
        this.httpOnly = builder.httpOnly;
    }

    @Override
    public Optional<CsrfToken> getToken(HttpServletRequest request, HttpServletResponse response, boolean create) {
        for (Cookie cookie : request.getCookies()) {
            if (!Objects.equals(cookie.getName(), this.cookieName)) continue;
            return Optional.of(new CsrfToken(this.headerName, this.paramName, cookie.getValue()));
        }
        if (create) {
            CsrfToken token = new CsrfToken(this.headerName, this.paramName, UUID.randomUUID().toString());
            Cookie cookie = new Cookie(this.cookieName, token.getValue());
            cookie.setSecure(request.isSecure());
            cookie.setPath(request.getContextPath().isEmpty() ? "/" : request.getContextPath());
            cookie.setMaxAge(this.maxAge);
            cookie.setHttpOnly(this.httpOnly);
            response.addCookie(cookie);
            return Optional.of(token);
        }
        return Optional.empty();
    }

    public static final class Builder {
        private String headerName = "X-XSRF-TOKEN";
        private String paramName = "_csrf";
        private String cookieName = "XSRF-TOKEN";
        private int maxAge = -1;
        private boolean httpOnly = false;

        public Builder headerName(String headerName) {
            this.headerName = headerName;
            return this;
        }

        public Builder paramName(String paramName) {
            this.paramName = paramName;
            return this;
        }

        public Builder cookieName(String cookieName) {
            this.cookieName = cookieName;
            return this;
        }

        public Builder maxAge(int maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public Builder httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public CookieCsrfTokenStrategy build() {
            return new CookieCsrfTokenStrategy(this);
        }
    }
}

