/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.security;

import java.io.IOException;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.mvc.annotation.Controller;
import javax.mvc.security.Csrf;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import org.mvcspec.ozark.OzarkConfig;
import org.mvcspec.ozark.security.CsrfToken;
import org.mvcspec.ozark.security.CsrfTokenManager;

@Controller
@Priority(value=3000)
public class CsrfProtectFilter
implements ContainerResponseFilter {
    @Inject
    private CsrfTokenManager csrfTokenManager;
    @Inject
    private OzarkConfig ozarkConfig;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (this.isCsrfEnabled()) {
            CsrfToken token = this.csrfTokenManager.getOrCreateToken();
            MultivaluedMap headers = responseContext.getHeaders();
            if (!headers.containsKey((Object)token.getHeaderName())) {
                headers.putSingle((Object)token.getHeaderName(), (Object)token.getValue());
            }
        }
    }

    private boolean isCsrfEnabled() {
        return this.ozarkConfig.getCsrfOptions() != Csrf.CsrfOptions.OFF;
    }
}

