/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.security;

import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mvcspec.ozark.OzarkConfig;
import org.mvcspec.ozark.jaxrs.JaxRsContext;
import org.mvcspec.ozark.security.CsrfToken;
import org.mvcspec.ozark.security.CsrfTokenStrategy;

@ApplicationScoped
public class CsrfTokenManager {
    private static final Logger log = Logger.getLogger(CsrfTokenManager.class.getName());
    private CsrfTokenStrategy tokenStrategy;
    @Inject
    @JaxRsContext
    private HttpServletRequest request;
    @Inject
    @JaxRsContext
    private HttpServletResponse response;
    @Inject
    private OzarkConfig ozarkConfig;

    @PostConstruct
    public void init() {
        this.tokenStrategy = this.ozarkConfig.getCsrfTokenStrategy();
        log.log(Level.FINE, "Configured strategy for CSRF tokens: {0}", new Object[]{this.tokenStrategy.getClass().getName()});
    }

    public Optional<CsrfToken> getToken() {
        return this.tokenStrategy.getToken(this.request, this.response, false);
    }

    public CsrfToken getOrCreateToken() {
        return this.tokenStrategy.getToken(this.request, this.response, true).orElseThrow(() -> new IllegalStateException("Strategy did not create a token"));
    }
}

