/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.mvc.annotation.Controller;
import javax.mvc.annotation.CsrfValid;
import javax.ws.rs.POST;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import org.mvcspec.ozark.OzarkConfig;
import org.mvcspec.ozark.core.Messages;
import org.mvcspec.ozark.security.CsrfToken;
import org.mvcspec.ozark.security.CsrfTokenManager;
import org.mvcspec.ozark.security.CsrfValidationException;
import org.mvcspec.ozark.util.AnnotationUtils;

@Controller
@Priority(value=3000)
public class CsrfValidateInterceptor
implements ReaderInterceptor {
    private static final int BUFFER_SIZE = 4096;
    private static final String DEFAULT_CHARSET = "UTF-8";
    @Inject
    private CsrfTokenManager csrfTokenManager;
    @Inject
    private OzarkConfig ozarkConfig;
    @Context
    private ResourceInfo resourceInfo;
    @Inject
    private Messages messages;

    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        Method controller = this.resourceInfo.getResourceMethod();
        if (this.needsValidation(controller)) {
            CsrfToken token = this.csrfTokenManager.getToken().orElseThrow(() -> new CsrfValidationException(this.messages.get("CsrfFailed", "missing token")));
            String csrfToken = (String)context.getHeaders().getFirst((Object)token.getHeaderName());
            if (token.getValue().equals(csrfToken)) {
                return context.proceed();
            }
            MediaType contentType = context.getMediaType();
            if (!CsrfValidateInterceptor.isSupportedMediaType(contentType)) {
                throw new CsrfValidationException(this.messages.get("UnableValidateCsrf", context.getMediaType()));
            }
            InputStream is = context.getInputStream();
            ByteArrayInputStream bais = is instanceof ByteArrayInputStream ? (ByteArrayInputStream)is : this.copyStream(is);
            boolean validated = false;
            String charset = (String)contentType.getParameters().get("charset");
            String entity = this.toString(bais, charset != null ? charset : DEFAULT_CHARSET);
            String[] pairs = entity.split("\\&");
            for (int i = 0; i < pairs.length; ++i) {
                String[] fields = pairs[i].split("=");
                String nn = URLDecoder.decode(fields[0], DEFAULT_CHARSET);
                if (!token.getParamName().equals(nn)) continue;
                String vv = URLDecoder.decode(fields[1], DEFAULT_CHARSET);
                if (token.getValue().equals(vv)) {
                    validated = true;
                    break;
                }
                throw new CsrfValidationException(this.messages.get("CsrfFailed", "mismatching tokens"));
            }
            if (!validated) {
                throw new CsrfValidationException(this.messages.get("CsrfFailed", "missing field"));
            }
            bais.reset();
            context.setInputStream((InputStream)bais);
        }
        return context.proceed();
    }

    protected static boolean isSupportedMediaType(MediaType contentType) {
        return contentType != null && contentType.isCompatible(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }

    private ByteArrayInputStream copyStream(InputStream is) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int n;
            byte[] buffer = new byte[4096];
            while ((n = is.read(buffer)) >= 0) {
                baos.write(buffer, 0, n);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
    }

    private String toString(ByteArrayInputStream bais, String encoding) throws UnsupportedEncodingException {
        int n = 0;
        byte[] bb = new byte[bais.available()];
        while ((n = bais.read(bb, n, bb.length - n)) >= 0) {
        }
        bais.reset();
        return new String(bb, encoding);
    }

    private boolean needsValidation(Method controller) {
        if (controller == null || !AnnotationUtils.hasAnnotation(controller, POST.class)) {
            return false;
        }
        switch (this.ozarkConfig.getCsrfOptions()) {
            case OFF: {
                return false;
            }
            case IMPLICIT: {
                return true;
            }
            case EXPLICIT: {
                return AnnotationUtils.hasAnnotation(controller, CsrfValid.class);
            }
        }
        return false;
    }
}

