/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.security;

import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mvcspec.ozark.security.CsrfToken;
import org.mvcspec.ozark.security.CsrfTokenStrategy;

public class SessionCsrfTokenStrategy
implements CsrfTokenStrategy {
    private static final String SESSION_KEY = SessionCsrfTokenStrategy.class.getName() + ".TOKEN";
    private final String headerName;
    private final String paramName;

    private SessionCsrfTokenStrategy(Builder builder) {
        this.headerName = builder.headerName;
        this.paramName = builder.paramName;
    }

    @Override
    public Optional<CsrfToken> getToken(HttpServletRequest request, HttpServletResponse response, boolean create) {
        Object value;
        HttpSession session = request.getSession(false);
        if (session != null && (value = session.getAttribute(SESSION_KEY)) instanceof CsrfToken) {
            return Optional.of((CsrfToken)value);
        }
        if (create) {
            CsrfToken token = new CsrfToken(this.headerName, this.paramName, UUID.randomUUID().toString());
            request.getSession(true).setAttribute(SESSION_KEY, (Object)token);
            return Optional.of(token);
        }
        return Optional.empty();
    }

    public static final class Builder {
        private String headerName = "X-CSRF-TOKEN";
        private String paramName = "_csrf";

        public Builder headerName(String headerName) {
            this.headerName = headerName;
            return this;
        }

        public Builder paramName(String paramName) {
            this.paramName = paramName;
            return this;
        }

        public SessionCsrfTokenStrategy build() {
            return new SessionCsrfTokenStrategy(this);
        }
    }
}

