/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.servlet;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mvc.annotation.Controller;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import org.mvcspec.ozark.util.AnnotationUtils;

@HandlesTypes(value={ApplicationPath.class, Path.class})
public class OzarkContainerInitializer
implements ServletContainerInitializer {
    public static final String APP_PATH_CONTEXT_KEY = OzarkContainerInitializer.class.getName() + ".APP_PATH";
    public static final String OZARK_CONTROLLERS_FOUND = "ozark.controllers-found";
    private static final Logger LOG = Logger.getLogger(OzarkContainerInitializer.class.getName());

    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        servletContext.setAttribute(OZARK_CONTROLLERS_FOUND, (Object)false);
        if (classes != null && !classes.isEmpty()) {
            LOG.log(Level.INFO, "Ozark version {0} started", this.getClass().getPackage().getImplementationVersion());
            for (Class<?> clazz : classes) {
                ApplicationPath ap = AnnotationUtils.getAnnotation(clazz, ApplicationPath.class);
                if (ap != null) {
                    if (servletContext.getAttribute(APP_PATH_CONTEXT_KEY) != null) {
                        throw new IllegalStateException("More than one JAX-RS ApplicationPath detected!");
                    }
                    servletContext.setAttribute(APP_PATH_CONTEXT_KEY, (Object)ap.value());
                }
                if (AnnotationUtils.hasAnnotationOnClassOrMethod(clazz, Path.class) && AnnotationUtils.hasAnnotationOnClassOrMethod(clazz, Controller.class)) {
                    servletContext.setAttribute(OZARK_CONTROLLERS_FOUND, (Object)true);
                }
                if (servletContext.getAttribute(APP_PATH_CONTEXT_KEY) == null || !((Boolean)servletContext.getAttribute(OZARK_CONTROLLERS_FOUND)).booleanValue()) continue;
                break;
            }
        }
    }
}

