/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.uri;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.Vetoed;
import javax.mvc.MvcUriBuilder;
import javax.mvc.annotation.UriRef;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.mvcspec.ozark.uri.DefaultMvcUriBuilder;
import org.mvcspec.ozark.uri.UriTemplate;
import org.mvcspec.ozark.util.AnnotationUtils;

@Vetoed
public class ApplicationUris {
    private MultivaluedMap<String, UriTemplate> uriTemplates = new MultivaluedHashMap();

    public URI get(String identifier) {
        return this.getUriBuilder(identifier).build();
    }

    public URI get(String identifier, Map<String, Object> params) {
        MvcUriBuilder uriBuilder = this.getUriBuilder(identifier);
        params.forEach((x$0, xva$1) -> uriBuilder.param(x$0, new Object[]{xva$1}));
        return uriBuilder.build();
    }

    public MvcUriBuilder getUriBuilder(String identifier) {
        return new DefaultMvcUriBuilder(this.getUriTemplate(identifier));
    }

    void register(UriTemplate uriTemplate, Method method) {
        UriRef uriRef = AnnotationUtils.getAnnotation(method, UriRef.class);
        if (uriRef != null) {
            this.merge(uriRef.value(), uriTemplate);
        }
        String identifier = String.format("%s#%s", method.getDeclaringClass().getSimpleName(), method.getName());
        this.merge(identifier, uriTemplate);
    }

    private void merge(String identifier, UriTemplate uriTemplate) {
        if (!this.uriTemplates.containsKey((Object)identifier)) {
            this.uriTemplates.add((Object)identifier, (Object)uriTemplate);
            return;
        }
        Optional<UriTemplate> existingTemplate = ((List)this.uriTemplates.get((Object)identifier)).stream().filter(template -> template.path().equals(uriTemplate.path())).findFirst();
        if (existingTemplate.isPresent()) {
            UriTemplate template2 = existingTemplate.get();
            template2.queryParams().addAll(uriTemplate.queryParams());
            template2.matrixParams().addAll(uriTemplate.matrixParams());
        } else {
            this.uriTemplates.add((Object)identifier, (Object)uriTemplate);
        }
    }

    private UriTemplate getUriTemplate(String identifier) {
        Objects.requireNonNull(identifier, "identifier must not be null");
        if (!this.uriTemplates.containsKey((Object)identifier)) {
            throw new IllegalArgumentException(String.format("No uriTemplate registered for identifier '%s'", identifier));
        }
        List registeredTemplats = (List)this.uriTemplates.get((Object)identifier);
        if (registeredTemplats.size() > 1) {
            throw new IllegalArgumentException(String.format("Ambiguous usage of identifier '%s' for following URIs: %s", identifier, registeredTemplats.stream().map(UriTemplate::path).collect(Collectors.toList())));
        }
        return (UriTemplate)this.uriTemplates.getFirst((Object)identifier);
    }

    Set<Map.Entry<String, List<UriTemplate>>> list() {
        return this.uriTemplates.entrySet();
    }

    public String toString() {
        return "ApplicationUris{uriTemplates=" + this.uriTemplates + '}';
    }
}

