/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.uri;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import javax.mvc.MvcUriBuilder;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.mvcspec.ozark.uri.UriTemplate;

class DefaultMvcUriBuilder
implements MvcUriBuilder {
    private final UriTemplate uriTemplate;
    private MultivaluedMap<String, Object> parameters = new MultivaluedHashMap();

    DefaultMvcUriBuilder(UriTemplate UriTemplate2) {
        Objects.requireNonNull(UriTemplate2, "uriTemplate must not be null");
        this.uriTemplate = UriTemplate2;
    }

    public MvcUriBuilder param(String name, Object ... values) {
        Objects.requireNonNull(values, "name must not be null");
        Objects.requireNonNull(values, "values must not be null");
        Arrays.stream(values).forEach(value -> {
            Set<Object> vals = value instanceof Iterable ? (Set<Object>)value : Collections.singleton(value);
            vals.forEach(val -> this.parameters.add((Object)name, val));
        });
        return this;
    }

    public URI build() {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.uriTemplate.path());
        HashMap pathParams = new HashMap();
        this.parameters.forEach((key, value) -> {
            if (this.uriTemplate.queryParams().contains(key)) {
                value.forEach(val -> uriBuilder.queryParam(key, new Object[]{val}));
            } else if (this.uriTemplate.matrixParams().contains(key)) {
                value.forEach(val -> uriBuilder.matrixParam(key, new Object[]{val}));
            } else {
                pathParams.put(key, value.get(0));
            }
        });
        return uriBuilder.buildFromMap(pathParams);
    }
}

