/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.uri;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class UriTemplate {
    private final String path;
    private final Set<String> queryParams;
    private final Set<String> matrixParams;

    private UriTemplate(String path, Set<String> queryParams, Set<String> matrixParams) {
        this.path = path;
        this.queryParams = queryParams;
        this.matrixParams = matrixParams;
    }

    static Builder fromTemplate(String template) {
        return new Builder(template);
    }

    public String path() {
        return this.path;
    }

    Set<String> queryParams() {
        return this.queryParams;
    }

    Set<String> matrixParams() {
        return this.matrixParams;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        UriTemplate that = (UriTemplate)other;
        return Objects.equals(this.path, that.path) && Objects.equals(this.queryParams, that.queryParams) && Objects.equals(this.matrixParams, that.matrixParams);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.queryParams, this.matrixParams);
    }

    public String toString() {
        return String.format("UriTemplate { path: %s, queryParams: %s, matrixParams: %s }", this.path, this.queryParams, this.matrixParams);
    }

    static class Builder {
        private String path;
        private Set<String> queryParams;
        private Set<String> matrixParams;

        Builder(String path) {
            Objects.requireNonNull(path, "path must not be null");
            this.path = path;
        }

        Builder queryParam(String queryParam) {
            if (this.queryParams == null) {
                this.queryParams = new HashSet<String>();
            }
            this.queryParams.add(queryParam);
            return this;
        }

        Builder matrixParam(String matrixParam) {
            if (this.matrixParams == null) {
                this.matrixParams = new HashSet<String>();
            }
            this.matrixParams.add(matrixParam);
            return this;
        }

        UriTemplate build() {
            return new UriTemplate(this.path, this.queryParams == null ? Collections.emptySet() : this.queryParams, this.matrixParams == null ? Collections.emptySet() : this.matrixParams);
        }
    }
}

