/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.uri;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.mvc.MvcContext;
import javax.ws.rs.BeanParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import org.mvcspec.ozark.uri.ApplicationUris;
import org.mvcspec.ozark.uri.UriTemplate;
import org.mvcspec.ozark.util.AnnotationUtils;
import org.mvcspec.ozark.util.BeanUtils;
import org.mvcspec.ozark.util.ControllerUtils;

@ApplicationScoped
public class UriTemplateParser {
    @Inject
    MvcContext mvcContext;
    @Context
    Application application;
    @Produces
    @ApplicationScoped
    private ApplicationUris applicationUris;

    @PostConstruct
    public void init() {
        this.applicationUris = this.init(this.controllers());
    }

    ApplicationUris init(Set<Class<?>> controllers) {
        ApplicationUris uris = new ApplicationUris();
        controllers.forEach(controller -> Stream.of(controller.getMethods()).filter(ControllerUtils::isControllerMethod).forEach(method -> {
            UriTemplate uriTemplate = this.parseMethod((Method)method, this.mvcContext.getBasePath());
            uris.register(uriTemplate, (Method)method);
        }));
        return uris;
    }

    UriTemplate parseMethod(Method method, String basePath) {
        Path methodPath;
        UriBuilder uriBuilder = UriBuilder.fromPath((String)basePath);
        Path controllerPath = AnnotationUtils.getAnnotation(method.getDeclaringClass(), Path.class);
        if (controllerPath != null) {
            uriBuilder.path(controllerPath.value());
        }
        if ((methodPath = AnnotationUtils.getAnnotation(method, Path.class)) != null) {
            uriBuilder.path(methodPath.value());
        }
        UriTemplate.Builder uriTemplateBuilder = UriTemplate.fromTemplate(uriBuilder.toTemplate());
        List<AnnotatedElement> annotatedElements = BeanUtils.getFieldsAndAccessors(method.getDeclaringClass());
        Arrays.asList(method.getParameters()).forEach(param -> {
            if (param.isAnnotationPresent(BeanParam.class)) {
                annotatedElements.addAll(BeanUtils.getFieldsAndAccessors(param.getType()));
            } else {
                annotatedElements.add((AnnotatedElement)param);
            }
        });
        annotatedElements.forEach(accessibleObject -> {
            if (accessibleObject.isAnnotationPresent(QueryParam.class)) {
                uriTemplateBuilder.queryParam(accessibleObject.getAnnotation(QueryParam.class).value());
            }
            if (accessibleObject.isAnnotationPresent(MatrixParam.class)) {
                uriTemplateBuilder.matrixParam(accessibleObject.getAnnotation(MatrixParam.class).value());
            }
        });
        return uriTemplateBuilder.build();
    }

    private Set<Class<?>> controllers() {
        return Stream.concat(this.application.getClasses().stream(), this.application.getSingletons().stream().map(Object::getClass)).filter(ControllerUtils::isController).collect(Collectors.toSet());
    }
}

