/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;

public final class AnnotationUtils {
    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationType) {
        T an = clazz.getDeclaredAnnotation(annotationType);
        if (an == null && AnnotationUtils.isProxy(clazz)) {
            an = clazz.getSuperclass().getDeclaredAnnotation(annotationType);
        }
        return an;
    }

    private static boolean isProxy(Class<?> clazz) {
        Class<?> parent = clazz.getSuperclass();
        if (parent != null) {
            return clazz.getName().contains("$$") && clazz.getName().startsWith(parent.getName());
        }
        return false;
    }

    public static <T extends Annotation> boolean hasAnnotation(Class<?> clazz, Class<T> annotationType) {
        return AnnotationUtils.getAnnotation(clazz, annotationType) != null;
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotationType) {
        Class<?>[] interfaces;
        Class<?> clazz = method.getDeclaringClass();
        if (clazz == Object.class) {
            return null;
        }
        T an = method.getDeclaredAnnotation(annotationType);
        if (an != null) {
            return an;
        }
        if (AnnotationUtils.hasMvcOrJaxrsAnnotations(method)) {
            return null;
        }
        Class<?> superClass = method.getDeclaringClass().getSuperclass();
        if (superClass != null) {
            try {
                Method superMethod = superClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
                an = AnnotationUtils.getAnnotation(superMethod, annotationType);
            }
            catch (NoSuchMethodException superMethod) {
                // empty catch block
            }
            if (an != null) {
                return an;
            }
        }
        for (Class<?> in : interfaces = method.getDeclaringClass().getInterfaces()) {
            try {
                Method superMethod = in.getDeclaredMethod(method.getName(), method.getParameterTypes());
                an = AnnotationUtils.getAnnotation(superMethod, annotationType);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (an == null) continue;
            return an;
        }
        return null;
    }

    public static <T extends Annotation> boolean hasAnnotation(Method method, Class<T> annotationType) {
        return AnnotationUtils.getAnnotation(method, annotationType) != null;
    }

    public static <T extends Annotation> boolean hasAnnotationOnClassOrMethod(Class<?> clazz, Class<T> annotationType) {
        return AnnotationUtils.hasAnnotation(clazz, annotationType) || Arrays.stream(clazz.getMethods()).anyMatch(m -> AnnotationUtils.hasAnnotation(m, annotationType));
    }

    static boolean hasMvcOrJaxrsAnnotations(Method method) {
        return Arrays.stream(method.getDeclaredAnnotations()).anyMatch(a -> {
            String an = a.annotationType().getName();
            return an.startsWith("javax.mvc.") || an.startsWith("javax.ws.rs.");
        });
    }
}

