/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class BeanUtils {
    private BeanUtils() {
    }

    public static List<AnnotatedElement> getFieldsAndAccessors(Class<?> clazz) {
        ArrayList<AnnotatedElement> properties = new ArrayList<AnnotatedElement>();
        properties.addAll(Arrays.stream(clazz.getDeclaredFields()).filter(f -> !f.isSynthetic()).collect(Collectors.toList()));
        try {
            Arrays.asList(Introspector.getBeanInfo(clazz, Object.class).getPropertyDescriptors()).forEach(prop -> {
                if (prop.getReadMethod() != null) {
                    properties.add(prop.getReadMethod());
                }
                if (prop.getWriteMethod() != null) {
                    properties.add(prop.getWriteMethod());
                }
            });
        }
        catch (IntrospectionException ex) {
            throw new IllegalArgumentException(String.format("Could not parse properties from class %s", clazz), ex);
        }
        return properties;
    }
}

