/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;

@ApplicationScoped
public class CdiUtils {
    @Inject
    private BeanManager beanManager;

    public <T> T newBean(Class<T> clazz) {
        return CdiUtils.newBean(this.beanManager, clazz);
    }

    public static <T> T newBean(BeanManager bm, Class<T> clazz) {
        Set beans = bm.getBeans(clazz, new Annotation[0]);
        Bean bean = bm.resolve(beans);
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        return (T)bm.getReference(bean, clazz, ctx);
    }

    public static void addAnnotatedTypes(BeforeBeanDiscovery beforeBean, BeanManager bm, Class<?> ... types) {
        for (Class<?> type : types) {
            beforeBean.addAnnotatedType(bm.createAnnotatedType(type), type.getName());
        }
    }

    public static <T> List<T> getApplicationBeans(Class<T> type, Annotation ... qualifiers) {
        BeanManager manager = CdiUtils.getApplicationBeanManager();
        return manager.getBeans(type, qualifiers).stream().map(bean -> manager.getReference(bean, (Type)type, manager.createCreationalContext((Contextual)bean))).collect(Collectors.toList());
    }

    public static BeanManager getApplicationBeanManager() {
        return CDI.current().getBeanManager();
    }
}

