/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.util;

import java.util.Objects;

public final class PathUtils {
    public static String noStartingSlash(String path) {
        Objects.requireNonNull(path, "path must not be null");
        return PathUtils.hasStartingSlash(path) ? path.substring(1) : path;
    }

    public static boolean hasStartingSlash(String path) {
        Objects.requireNonNull(path, "path must not be null");
        return !"".equals(path) && path.charAt(0) == '/';
    }

    public static String noPrefix(String path, String prefix) {
        Objects.requireNonNull(path, "path must not be null");
        Objects.requireNonNull(prefix, "prefix must not be null");
        return path.startsWith(prefix) ? path.substring(prefix.length()) : path;
    }

    public static String ensureStartingSlash(String path) {
        Objects.requireNonNull(path, "path must not be null");
        return "".equals(path) || path.charAt(0) != '/' ? "/" + path : path;
    }

    public static String ensureEndingSlash(String path) {
        Objects.requireNonNull(path, "path must not be null");
        return "".equals(path) || path.charAt(path.length() - 1) != '/' ? path + "/" : path;
    }

    public static String ensureNotEndingSlash(String path) {
        Objects.requireNonNull(path, "path must not be null");
        if ("".equals(path)) {
            return path;
        }
        int length = path.length();
        return path.charAt(length - 1) == '/' ? path.substring(0, length - 1) : path;
    }

    public static String normalizePath(String path) {
        Objects.requireNonNull(path, "path must not be null");
        return path.isEmpty() || path.equals("/*") ? "" : PathUtils.ensureNotEndingSlash(PathUtils.ensureStartingSlash(path));
    }
}

