/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.ext.formatters;

import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonValue;
import javax.json.stream.JsonGeneratorFactory;
import org.jboss.logmanager.ext.formatters.StructuredFormatter;

public class JsonFormatter
extends StructuredFormatter {
    private final Map<String, Object> config = new HashMap<String, Object>();

    public JsonFormatter() {
        this(Collections.emptyMap());
    }

    public JsonFormatter(Map<StructuredFormatter.Key, String> keyOverrides) {
        super(keyOverrides);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPrettyPrint() {
        Map<String, Object> map = this.config;
        synchronized (map) {
            return this.config.containsKey("javax.json.stream.JsonGenerator.prettyPrinting") ? (Boolean)this.config.get("javax.json.stream.JsonGenerator.prettyPrinting") : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrettyPrint(boolean b) {
        Map<String, Object> map = this.config;
        synchronized (map) {
            if (b) {
                this.config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            } else {
                this.config.remove("javax.json.stream.JsonGenerator.prettyPrinting");
            }
        }
    }

    @Override
    protected StructuredFormatter.Generator createGenerator(Writer writer) {
        return new JsonGenerator(writer);
    }

    private class JsonGenerator
    extends StructuredFormatter.Generator {
        private final javax.json.stream.JsonGenerator generator;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JsonGenerator(Writer writer) {
            HashMap config;
            Map map = JsonFormatter.this.config;
            synchronized (map) {
                config = new HashMap(JsonFormatter.this.config);
            }
            JsonGeneratorFactory factory = Json.createGeneratorFactory(config);
            this.generator = factory.createGenerator(writer);
        }

        @Override
        public StructuredFormatter.Generator begin() {
            this.generator.writeStartObject();
            return this;
        }

        @Override
        public StructuredFormatter.Generator add(String key, int value) {
            this.generator.write(key, value);
            return this;
        }

        @Override
        public StructuredFormatter.Generator add(String key, long value) {
            this.generator.write(key, value);
            return this;
        }

        @Override
        public StructuredFormatter.Generator add(String key, Map<String, ?> value) {
            this.generator.writeStartObject(key);
            if (value != null) {
                for (Map.Entry<String, ?> entry : value.entrySet()) {
                    this.writeObject(entry.getKey(), entry.getValue());
                }
            }
            this.generator.writeEnd();
            return this;
        }

        @Override
        public StructuredFormatter.Generator add(String key, String value) {
            if (value == null) {
                this.generator.writeNull(key);
            } else {
                this.generator.write(key, value);
            }
            return this;
        }

        @Override
        public StructuredFormatter.Generator addStackTrace(Throwable throwable) throws Exception {
            if (throwable != null) {
                StackTraceElement[] elements;
                this.generator.writeStartObject(JsonFormatter.this.getKey(StructuredFormatter.Key.EXCEPTION));
                this.add(JsonFormatter.this.getKey(StructuredFormatter.Key.EXCEPTION_MESSAGE), throwable.getMessage());
                this.generator.writeStartArray(JsonFormatter.this.getKey(StructuredFormatter.Key.EXCEPTION_FRAMES));
                for (StackTraceElement e : elements = throwable.getStackTrace()) {
                    this.generator.writeStartObject();
                    this.add(JsonFormatter.this.getKey(StructuredFormatter.Key.EXCEPTION_FRAME_CLASS), e.getClassName());
                    this.add(JsonFormatter.this.getKey(StructuredFormatter.Key.EXCEPTION_FRAME_METHOD), e.getMethodName());
                    int line = e.getLineNumber();
                    if (line >= 0) {
                        this.add(JsonFormatter.this.getKey(StructuredFormatter.Key.EXCEPTION_FRAME_LINE), e.getLineNumber());
                    }
                    this.generator.writeEnd();
                }
                this.generator.writeEnd();
                this.generator.writeEnd();
            }
            return this;
        }

        @Override
        public StructuredFormatter.Generator end() {
            this.generator.writeEnd();
            this.generator.flush();
            this.generator.close();
            return this;
        }

        private void writeObject(String key, Object obj) {
            if (obj == null) {
                if (key == null) {
                    this.generator.writeNull();
                } else {
                    this.generator.writeNull(key);
                }
            } else if (obj instanceof Boolean) {
                Boolean value = (Boolean)obj;
                if (key == null) {
                    this.generator.write(value.booleanValue());
                } else {
                    this.generator.write(key, value.booleanValue());
                }
            } else if (obj instanceof Integer) {
                Integer value = (Integer)obj;
                if (key == null) {
                    this.generator.write(value.intValue());
                } else {
                    this.generator.write(key, value.intValue());
                }
            } else if (obj instanceof Long) {
                Long value = (Long)obj;
                if (key == null) {
                    this.generator.write(value.longValue());
                } else {
                    this.generator.write(key, value.longValue());
                }
            } else if (obj instanceof Double) {
                Double value = (Double)obj;
                if (key == null) {
                    this.generator.write(value.doubleValue());
                } else {
                    this.generator.write(key, value.doubleValue());
                }
            } else if (obj instanceof BigInteger) {
                BigInteger value = (BigInteger)obj;
                if (key == null) {
                    this.generator.write(value);
                } else {
                    this.generator.write(key, value);
                }
            } else if (obj instanceof BigDecimal) {
                BigDecimal value = (BigDecimal)obj;
                if (key == null) {
                    this.generator.write(value);
                } else {
                    this.generator.write(key, value);
                }
            } else if (obj instanceof String) {
                String value = (String)obj;
                if (key == null) {
                    this.generator.write(value);
                } else {
                    this.generator.write(key, value);
                }
            } else if (obj instanceof JsonValue) {
                JsonValue value = (JsonValue)obj;
                if (key == null) {
                    this.generator.write(value);
                } else {
                    this.generator.write(key, value);
                }
            } else {
                String value = String.valueOf(obj);
                if (key == null) {
                    this.generator.write(value);
                } else {
                    this.generator.write(key, value);
                }
            }
        }
    }
}

