/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.orientdb;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.orientdb.orient.Host;
import org.wildfly.swarm.config.orientdb.orient.HostConsumer;
import org.wildfly.swarm.config.orientdb.orient.HostSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=orientdb/orient=*")
@ResourceType(value="orient")
public class Orient<T extends Orient<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private OrientResources subresources = new OrientResources();
    @AttributeDocumentation(value="Database name")
    private String database;
    @AttributeDocumentation(value="Unique profile identification")
    private String id;
    @AttributeDocumentation(value="Database JNDI address")
    private String jndiName;
    @AttributeDocumentation(value="Max database pool partition size")
    private Integer maxPartitionSize;
    @AttributeDocumentation(value="Max database pool size")
    private Integer maxPoolSize;
    @AttributeDocumentation(value="Module name")
    private String module;
    @AttributeDocumentation(value="if true, Database is remote, if false, database is local (PLOCAL).")
    private Boolean remote;
    @AttributeDocumentation(value="Security domain name")
    private String securityDomain;

    public Orient(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public OrientResources subresources() {
        return this.subresources;
    }

    public T hosts(List<Host> value) {
        this.subresources.hosts = value;
        return (T)this;
    }

    public T host(Host value) {
        this.subresources.hosts.add(value);
        return (T)this;
    }

    public T host(String childKey, HostConsumer consumer) {
        Host child = new Host(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.host(child);
        return (T)this;
    }

    public T host(String childKey) {
        this.host(childKey, null);
        return (T)this;
    }

    public T host(HostSupplier supplier) {
        this.host(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="database")
    public String database() {
        return this.database;
    }

    public T database(String value) {
        String oldValue = this.database;
        this.database = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("database", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="id")
    public String id() {
        return this.id;
    }

    public T id(String value) {
        String oldValue = this.id;
        this.id = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("id", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jndi-name")
    public String jndiName() {
        return this.jndiName;
    }

    public T jndiName(String value) {
        String oldValue = this.jndiName;
        this.jndiName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jndiName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-partition-size")
    public Integer maxPartitionSize() {
        return this.maxPartitionSize;
    }

    public T maxPartitionSize(Integer value) {
        Integer oldValue = this.maxPartitionSize;
        this.maxPartitionSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxPartitionSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-pool-size")
    public Integer maxPoolSize() {
        return this.maxPoolSize;
    }

    public T maxPoolSize(Integer value) {
        Integer oldValue = this.maxPoolSize;
        this.maxPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxPoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="module")
    public String module() {
        return this.module;
    }

    public T module(String value) {
        String oldValue = this.module;
        this.module = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("module", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="remote")
    public Boolean remote() {
        return this.remote;
    }

    public T remote(Boolean value) {
        Boolean oldValue = this.remote;
        this.remote = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("remote", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-domain")
    public String securityDomain() {
        return this.securityDomain;
    }

    public T securityDomain(String value) {
        String oldValue = this.securityDomain;
        this.securityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityDomain", oldValue, value);
        }
        return (T)this;
    }

    public static class OrientResources {
        @ResourceDocumentation(value="OrientDB target profile definition")
        @SubresourceInfo(value="host")
        private List<Host> hosts = new ArrayList<Host>();

        @Subresource
        public List<Host> hosts() {
            return this.hosts;
        }

        public Host host(String key) {
            return this.hosts.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

