/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.orient.core.index.OAlwaysGreaterKey;
import com.orientechnologies.orient.core.index.OAlwaysLessKey;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.ODocumentSerializable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public class OCompositeKey
implements Comparable<OCompositeKey>,
Serializable,
ODocumentSerializable {
    private static final long serialVersionUID = 1L;
    private final List<Object> keys;
    private final transient Comparator<Object> comparator;

    public OCompositeKey(List<?> keys) {
        this.keys = new ArrayList<Object>(keys.size());
        this.comparator = ODefaultComparator.INSTANCE;
        for (Object key : keys) {
            this.addKey(key);
        }
    }

    public OCompositeKey(Object ... keys) {
        this.keys = new ArrayList<Object>(keys.length);
        this.comparator = ODefaultComparator.INSTANCE;
        for (Object key : keys) {
            this.addKey(key);
        }
    }

    public OCompositeKey() {
        this.keys = new ArrayList<Object>();
        this.comparator = ODefaultComparator.INSTANCE;
    }

    public void reset() {
        if (this.keys != null) {
            this.keys.clear();
        }
    }

    public List<Object> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    public void addKey(Object key) {
        if (key instanceof OCompositeKey) {
            OCompositeKey compositeKey = (OCompositeKey)key;
            for (Object inKey : compositeKey.keys) {
                this.addKey(inKey);
            }
        } else {
            this.keys.add(key);
        }
    }

    @Override
    public int compareTo(OCompositeKey otherKey) {
        Iterator<Object> inIter = this.keys.iterator();
        Iterator<Object> outIter = otherKey.keys.iterator();
        while (inIter.hasNext() && outIter.hasNext()) {
            Object inKey = inIter.next();
            Object outKey = outIter.next();
            if (outKey instanceof OAlwaysGreaterKey) {
                return -1;
            }
            if (outKey instanceof OAlwaysLessKey) {
                return 1;
            }
            if (inKey instanceof OAlwaysGreaterKey) {
                return 1;
            }
            if (inKey instanceof OAlwaysLessKey) {
                return -1;
            }
            int result = this.comparator.compare(inKey, outKey);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCompositeKey that = (OCompositeKey)o;
        return this.keys.equals(that.keys);
    }

    public int hashCode() {
        return this.keys.hashCode();
    }

    public String toString() {
        return "OCompositeKey{keys=" + this.keys + '}';
    }

    @Override
    public ODocument toDocument() {
        ODocument document = new ODocument();
        for (int i = 0; i < this.keys.size(); ++i) {
            document.field("key" + i, this.keys.get(i));
        }
        return document;
    }

    @Override
    public void fromDocument(ODocument document) {
        document.setLazyLoad(false);
        String[] fieldNames = document.fieldNames();
        TreeMap keyMap = new TreeMap();
        for (String fieldName : fieldNames) {
            if (!fieldName.startsWith("key")) continue;
            String keyIndex = fieldName.substring(3);
            keyMap.put(Integer.valueOf(keyIndex), document.field(fieldName));
        }
        this.keys.clear();
        for (Object value : keyMap.values()) {
            this.keys.add(value);
        }
    }
}

