/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.query.OQueryRuntimeValueMulti;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OBinaryField;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinary;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;

public abstract class OQueryOperatorEquality
extends OQueryOperator {
    protected OQueryOperatorEquality(String iKeyword, int iPrecedence, boolean iLogical) {
        super(iKeyword, iPrecedence, false);
    }

    protected OQueryOperatorEquality(String iKeyword, int iPrecedence, boolean iLogical, int iExpectedRightWords) {
        super(iKeyword, iPrecedence, false, iExpectedRightWords);
    }

    protected OQueryOperatorEquality(String iKeyword, int iPrecedence, boolean iLogical, int iExpectedRightWords, boolean iExpectsParameters) {
        super(iKeyword, iPrecedence, iLogical, iExpectedRightWords, iExpectsParameters);
    }

    protected abstract boolean evaluateExpression(OIdentifiable var1, OSQLFilterCondition var2, Object var3, Object var4, OCommandContext var5);

    public boolean evaluate(OBinaryField iFirstField, OBinaryField iSecondField, OCommandContext iContext) {
        Object left = ORecordSerializerBinary.INSTANCE.getCurrentSerializer().deserializeValue(iFirstField.bytes, iFirstField.type, null);
        Object right = ORecordSerializerBinary.INSTANCE.getCurrentSerializer().deserializeValue(iSecondField.bytes, iFirstField.type, null);
        return this.evaluateExpression(null, null, left, right, iContext);
    }

    @Override
    public Object evaluateRecord(OIdentifiable iRecord, ODocument iCurrentResult, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        if (iLeft instanceof OBinaryField && iRight instanceof OBinaryField) {
            return this.evaluate((OBinaryField)iLeft, (OBinaryField)iRight, iContext);
        }
        if (iLeft instanceof OQueryRuntimeValueMulti) {
            OQueryRuntimeValueMulti left = (OQueryRuntimeValueMulti)iLeft;
            if (left.getValues().length == 0) {
                return false;
            }
            if (left.getDefinition().getRoot().startsWith("ALL")) {
                for (int i = 0; i < left.getValues().length; ++i) {
                    Object v = left.getValues()[i];
                    Object r = iRight;
                    OCollate collate = left.getCollate(i);
                    if (collate != null) {
                        v = collate.transform(v);
                        r = collate.transform(iRight);
                    }
                    if (v != null && this.evaluateExpression(iRecord, iCondition, v, r, iContext)) continue;
                    return false;
                }
                return true;
            }
            for (int i = 0; i < left.getValues().length; ++i) {
                Object v = left.getValues()[i];
                Object r = iRight;
                OCollate collate = left.getCollate(i);
                if (collate != null) {
                    v = collate.transform(v);
                    r = collate.transform(iRight);
                }
                if (v == null || !this.evaluateExpression(iRecord, iCondition, v, r, iContext)) continue;
                return true;
            }
            return false;
        }
        if (iRight instanceof OQueryRuntimeValueMulti) {
            OQueryRuntimeValueMulti right = (OQueryRuntimeValueMulti)iRight;
            if (right.getValues().length == 0) {
                return false;
            }
            if (right.getDefinition().getRoot().startsWith("ALL")) {
                for (int i = 0; i < right.getValues().length; ++i) {
                    Object v = right.getValues()[i];
                    Object l = iLeft;
                    OCollate collate = right.getCollate(i);
                    if (collate != null) {
                        v = collate.transform(v);
                        l = collate.transform(iLeft);
                    }
                    if (v != null && this.evaluateExpression(iRecord, iCondition, l, v, iContext)) continue;
                    return false;
                }
                return true;
            }
            for (int i = 0; i < right.getValues().length; ++i) {
                Object v = right.getValues()[i];
                Object l = iLeft;
                OCollate collate = right.getCollate(i);
                if (collate != null) {
                    v = collate.transform(v);
                    l = collate.transform(iLeft);
                }
                if (v == null || !this.evaluateExpression(iRecord, iCondition, l, v, iContext)) continue;
                return true;
            }
            return false;
        }
        return this.evaluateExpression(iRecord, iCondition, iLeft, iRight, iContext);
    }
}

