/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.openapi.runtime.scanner;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.openapi.runtime.util.TypeUtil;

public class TypeResolver {
    private static final Logger LOG = Logger.getLogger(TypeResolver.class);
    private Deque<Map<String, Type>> resolutionStack;
    private Type leaf;

    private TypeResolver(Type leaf, Deque<Map<String, Type>> resolutionStack) {
        this.leaf = leaf;
        this.resolutionStack = resolutionStack;
    }

    public Type resolveType() {
        return this.getResolvedType(this.leaf);
    }

    public Type getResolvedType(Type fieldType) {
        Type current = TypeUtil.resolveWildcard(fieldType);
        for (Map<String, Type> map : this.resolutionStack) {
            if (current.kind() == Type.Kind.TYPE_VARIABLE) {
                current = map.get(current.asTypeVariable().identifier());
                continue;
            }
            if (current.kind() == Type.Kind.UNRESOLVED_TYPE_VARIABLE) {
                current = map.get(current.asUnresolvedTypeVariable().identifier());
                continue;
            }
            return current;
        }
        return current;
    }

    public static Map<FieldInfo, TypeResolver> getAllFields(IndexView index, Type leaf, ClassInfo leafKlazz) {
        LinkedHashMap<FieldInfo, TypeResolver> fields = new LinkedHashMap<FieldInfo, TypeResolver>();
        Type currentType = leaf;
        ClassInfo currentClass = leafKlazz;
        ArrayDeque<Map<String, Type>> stack = new ArrayDeque<Map<String, Type>>();
        do {
            if (currentType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                Map<String, Type> resMap = TypeResolver.buildParamTypeResolutionMap(currentClass, currentType.asParameterizedType());
                stack.push(resMap);
            }
            for (FieldInfo field : currentClass.fields()) {
                TypeResolver resolver = new TypeResolver(field.type(), new ArrayDeque<Map<String, Type>>(stack));
                fields.put(field, resolver);
            }
        } while ((currentType = currentClass.superClassType()) != null && (currentClass = TypeResolver.getClassByName(index, currentType)) != null && currentClass.superClassType() != null);
        return fields;
    }

    private static Map<String, Type> buildParamTypeResolutionMap(ClassInfo klazz, ParameterizedType parameterizedType) {
        List typeVariables = klazz.typeParameters();
        List arguments = parameterizedType.arguments();
        if (arguments.size() != typeVariables.size()) {
            LOG.errorv("Unanticipated mismatch between type arguments and type variables \nArgs: {0}\n Vars:{1}", (Object)arguments, (Object)typeVariables);
        }
        LinkedHashMap<String, Type> resolutionMap = new LinkedHashMap<String, Type>();
        for (int i = 0; i < arguments.size(); ++i) {
            TypeVariable typeVar = (TypeVariable)typeVariables.get(i);
            Type arg = (Type)arguments.get(i);
            resolutionMap.put(typeVar.identifier(), arg);
        }
        return resolutionMap;
    }

    private static ClassInfo getClassByName(IndexView index, @NotNull Type type) {
        return index.getClassByName(TypeUtil.getName(type));
    }
}

