/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.group.CacheGroupConfiguration;
import org.wildfly.clustering.server.group.InfinispanNodeFactory;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.service.concurrent.ClassLoaderThreadFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener
public class CacheGroup
implements Group,
AutoCloseable {
    private final Map<Group.Listener, ExecutorService> listeners = new ConcurrentHashMap<Group.Listener, ExecutorService>();
    private final Cache<?, ?> cache;
    private final InfinispanNodeFactory factory;
    private final SortedMap<Integer, Boolean> views = Collections.synchronizedSortedMap(new TreeMap());

    private static ThreadFactory createThreadFactory(Class<?> targetClass) {
        PrivilegedAction<ThreadFactory> action = () -> new JBossThreadFactory(new ThreadGroup(targetClass.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
        return new ClassLoaderThreadFactory((ThreadFactory)WildFlySecurityManager.doUnchecked(action), targetClass.getClassLoader());
    }

    public CacheGroup(CacheGroupConfiguration config) {
        this.cache = config.getCache();
        this.factory = config.getNodeFactory();
        this.cache.getCacheManager().addListener((Object)this);
        this.cache.addListener((Object)this);
    }

    @Override
    public void close() {
        this.cache.removeListener((Object)this);
        this.cache.getCacheManager().removeListener((Object)this);
        this.listeners.values().forEach(executor -> {
            PrivilegedAction<List> action = () -> executor.shutdownNow();
            WildFlySecurityManager.doUnchecked(action);
        });
        this.listeners.clear();
    }

    public String getName() {
        return this.cache.getCacheManager().getClusterName();
    }

    public boolean isCoordinator() {
        return this.cache.getCacheManager().getAddress().equals(this.getCoordinator());
    }

    public Node getLocalNode() {
        return this.factory.createNode(this.cache.getCacheManager().getAddress());
    }

    public Node getCoordinatorNode() {
        return this.factory.createNode(this.getCoordinator());
    }

    private Address getCoordinator() {
        DistributionManager dist = this.cache.getAdvancedCache().getDistributionManager();
        return dist != null ? (Address)dist.getConsistentHash().getMembers().get(0) : this.cache.getCacheManager().getCoordinator();
    }

    public List<Node> getNodes() {
        List<Address> addresses = this.getAddresses();
        if (addresses == null) {
            return Collections.singletonList(this.getLocalNode());
        }
        ArrayList<Node> nodes = new ArrayList<Node>(addresses.size());
        for (Address address : addresses) {
            nodes.add(this.factory.createNode(address));
        }
        return nodes;
    }

    @Merged
    @ViewChanged
    public void viewChanged(ViewChangedEvent event) {
        this.views.put(event.getViewId(), event.isMergeView());
    }

    @TopologyChanged
    public void topologyChanged(TopologyChangedEvent<?, ?> event) {
        if (event.isPre()) {
            return;
        }
        List oldAddresses = event.getConsistentHashAtStart().getMembers();
        List<Node> oldNodes = this.getNodes(oldAddresses);
        List newAddresses = event.getConsistentHashAtEnd().getMembers();
        List<Node> newNodes = this.getNodes(newAddresses);
        HashSet obsolete = new HashSet(oldAddresses);
        obsolete.removeAll(newAddresses);
        this.factory.invalidate(obsolete);
        int viewId = event.getCache().getCacheManager().getTransport().getViewId();
        Boolean status = (Boolean)this.views.get(viewId);
        boolean merged = status != null ? status : false;
        this.listeners.forEach((listener, executor) -> {
            try {
                executor.submit(() -> {
                    try {
                        listener.membershipChanged(oldNodes, newNodes, merged);
                    }
                    catch (Throwable e) {
                        ClusteringServerLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        });
        this.views.headMap(viewId).clear();
    }

    private List<Node> getNodes(List<Address> addresses) {
        ArrayList<Node> nodes = new ArrayList<Node>(addresses.size());
        for (Address address : addresses) {
            nodes.add(this.factory.createNode(address));
        }
        return nodes;
    }

    public void addListener(Group.Listener listener) {
        this.listeners.computeIfAbsent(listener, key -> Executors.newSingleThreadExecutor(CacheGroup.createThreadFactory(listener.getClass())));
    }

    public void removeListener(Group.Listener listener) {
        ExecutorService executor = this.listeners.remove(listener);
        if (executor != null) {
            PrivilegedAction<List> action = () -> executor.shutdownNow();
            WildFlySecurityManager.doUnchecked(action);
            try {
                executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private List<Address> getAddresses() {
        DistributionManager dist = this.cache.getAdvancedCache().getDistributionManager();
        return dist != null ? dist.getConsistentHash().getMembers() : this.cache.getCacheManager().getMembers();
    }

    public boolean isLocal() {
        return !this.cache.getCacheConfiguration().clustering().cacheMode().isClustered();
    }
}

