/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.mongodb.mongo;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=mongodb/mongo=*/properties=*")
@ResourceType(value="properties")
public class Properties<T extends Properties<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Custom MongoDB property")
    private Map property;

    public Properties(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="property")
    public Map property() {
        return this.property;
    }

    public T property(Map value) {
        Map oldValue = this.property;
        this.property = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("property", oldValue, value);
        }
        return (T)this;
    }

    public T property(String key, Object value) {
        if (this.property == null) {
            this.property = new HashMap();
        }
        this.property.put(key, value);
        return (T)this;
    }
}

