/* Generated By:JJTree: Do not edit this line. OSuffixIdentifier.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;

import java.util.Map;

public class OSuffixIdentifier extends SimpleNode {

  protected OIdentifier      identifier;
  protected ORecordAttribute recordAttribute;
  protected boolean          star = false;

  public OSuffixIdentifier(int id) {
    super(id);
  }

  public OSuffixIdentifier(OrientSql p, int id) {
    super(p, id);
  }

  /** Accept the visitor. **/
  public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
    return visitor.visit(this, data);
  }

  public void toString(Map<Object, Object> params, StringBuilder builder) {
    if (identifier != null) {
      identifier.toString(params, builder);
    } else if (recordAttribute != null) {
      recordAttribute.toString(params, builder);
    } else if (star) {
      builder.append("*");
    }
  }

  public Object execute(OIdentifiable iCurrentRecord, OCommandContext ctx) {
    if (star) {
      return iCurrentRecord;
    }
    if (identifier != null) {
      String varName = identifier.getStringValue();
      if (ctx!=null && ctx.getVariable(varName) != null) {
        return ctx.getVariable(varName);
      }
      if(iCurrentRecord != null) {
        return ((ODocument) iCurrentRecord.getRecord()).field(varName);
      }
      return null;
    }
    if (recordAttribute != null) {
      return ((ODocument) iCurrentRecord.getRecord()).field(recordAttribute.name);
    }
    return null;
  }

  public Object execute(Object currentValue, OCommandContext ctx) {
    if (currentValue == null) {
      return null;
    }
    if (star) {
      return currentValue;
    }
    if (identifier != null) {
      String varName = identifier.getStringValue();
      if (ctx.getVariable(varName) != null) {
        return ctx.getVariable(varName);
      }
      if (currentValue instanceof OIdentifiable) {
        return ((ODocument) ((OIdentifiable) currentValue).getRecord()).field(varName);
      }
      if (currentValue instanceof Map) {
        return ((Map) currentValue).get(varName);
      }
      throw new UnsupportedOperationException("Implement SuffixIdentifier!");
      // TODO other cases?
    }
    if (recordAttribute != null) {
      if (currentValue instanceof OIdentifiable) {
        return ((ODocument) ((OIdentifiable) currentValue).getRecord()).field(recordAttribute.name);
      }
      if (currentValue instanceof Map) {
        return ((Map) currentValue).get(recordAttribute.name);
      }
      throw new UnsupportedOperationException("Implement SuffixIdentifier!");
      // TODO other cases?
    }
    return null;
  }

  public boolean isBaseIdentifier() {
    return identifier != null;
  }
}
/* JavaCC - OriginalChecksum=5d9be0188c7d6e2b67d691fb88a518f8 (do not edit this line) */
