/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.camel.component.mllp.MllpAcknowledgementDeliveryException;
import org.apache.camel.component.mllp.MllpException;
import org.apache.camel.component.mllp.MllpWriteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MllpSocketWriter {
    static final byte[] PAYLOAD_TERMINATOR = new byte[2];
    final Socket socket;
    final boolean acknowledgementWriter;
    Logger log = LoggerFactory.getLogger(this.getClass());

    public MllpSocketWriter(Socket socket, boolean acknowledgementWriter) {
        this.socket = socket;
        this.acknowledgementWriter = acknowledgementWriter;
    }

    public void writeEnvelopedPayload(byte[] hl7MessageBytes, byte[] hl7AcknowledgementBytes) throws MllpException {
        if (this.socket == null) {
            String errorMessage = "Socket is null";
            if (this.isAcknowledgementWriter()) {
                throw new MllpAcknowledgementDeliveryException("Socket is null", hl7MessageBytes, hl7AcknowledgementBytes);
            }
            throw new MllpWriteException("Socket is null", hl7MessageBytes);
        }
        if (!this.socket.isConnected()) {
            String errorMessage = "Socket is not connected";
            if (this.isAcknowledgementWriter()) {
                throw new MllpAcknowledgementDeliveryException("Socket is not connected", hl7MessageBytes, hl7AcknowledgementBytes);
            }
            throw new MllpWriteException("Socket is not connected", hl7MessageBytes);
        }
        if (this.socket.isClosed()) {
            String errorMessage = "Socket is closed";
            if (this.isAcknowledgementWriter()) {
                throw new MllpAcknowledgementDeliveryException("Socket is closed", hl7MessageBytes, hl7AcknowledgementBytes);
            }
            throw new MllpWriteException("Socket is closed", hl7MessageBytes);
        }
        OutputStream socketOutputStream = null;
        try {
            socketOutputStream = this.socket.getOutputStream();
        }
        catch (IOException e) {
            String errorMessage = "Failed to retrieve the OutputStream from the Socket";
            if (this.isAcknowledgementWriter()) {
                throw new MllpAcknowledgementDeliveryException("Failed to retrieve the OutputStream from the Socket", hl7MessageBytes, hl7AcknowledgementBytes);
            }
            throw new MllpWriteException("Failed to retrieve the OutputStream from the Socket", hl7MessageBytes, hl7AcknowledgementBytes);
        }
        try {
            socketOutputStream.write(11);
        }
        catch (IOException e) {
            String errorMessage = "Failed to write the START_OF_BLOCK to the Socket's OutputStream";
            if (this.isAcknowledgementWriter()) {
                throw new MllpAcknowledgementDeliveryException("Failed to write the START_OF_BLOCK to the Socket's OutputStream", hl7MessageBytes, hl7AcknowledgementBytes);
            }
            throw new MllpWriteException("Failed to write the START_OF_BLOCK to the Socket's OutputStream", hl7MessageBytes, hl7AcknowledgementBytes);
        }
        if (this.isAcknowledgementWriter()) {
            if (hl7AcknowledgementBytes == null) {
                this.log.warn("HL7 Acknowledgement payload is null - sending empty MLLP payload");
            } else if (hl7AcknowledgementBytes.length <= 0) {
                this.log.warn("HL7 Acknowledgement payload is empty - sending empty MLLP payload");
            } else {
                try {
                    socketOutputStream.write(hl7AcknowledgementBytes);
                }
                catch (IOException ioEx) {
                    throw new MllpAcknowledgementDeliveryException("Failed to write the HL7 Acknowledgement payload to the Socket's OutputStream", hl7MessageBytes, hl7AcknowledgementBytes, ioEx);
                }
            }
        } else if (hl7MessageBytes == null) {
            this.log.warn("HL7 Message payload is null - sending empty MLLP payload");
        } else if (hl7MessageBytes.length <= 0) {
            this.log.warn("HL7 Message payload is empty - sending empty MLLP payload");
        } else {
            try {
                socketOutputStream.write(hl7MessageBytes);
            }
            catch (IOException ioEx) {
                throw new MllpWriteException("Failed to write the HL7 Message payload to the Socket's OutputStream", hl7MessageBytes, hl7AcknowledgementBytes, ioEx);
            }
        }
        try {
            socketOutputStream.write(PAYLOAD_TERMINATOR);
            socketOutputStream.flush();
        }
        catch (IOException e) {
            String errorMessage = "Failed to write the END_OF_BLOCK and END_OF_DATA to the Socket's OutputStream";
            if (this.isAcknowledgementWriter()) {
                throw new MllpAcknowledgementDeliveryException("Failed to write the END_OF_BLOCK and END_OF_DATA to the Socket's OutputStream", hl7MessageBytes, hl7AcknowledgementBytes);
            }
            throw new MllpWriteException("Failed to write the END_OF_BLOCK and END_OF_DATA to the Socket's OutputStream", hl7MessageBytes, hl7AcknowledgementBytes);
        }
    }

    public boolean isAcknowledgementWriter() {
        return this.acknowledgementWriter;
    }

    static {
        MllpSocketWriter.PAYLOAD_TERMINATOR[0] = 28;
        MllpSocketWriter.PAYLOAD_TERMINATOR[1] = 13;
    }
}

