/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.zipfile;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.dataformat.zipfile.ZipInputStreamWrapper;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipIterator
implements Iterator<Message>,
Closeable {
    static final Logger LOGGER = LoggerFactory.getLogger(ZipIterator.class);
    private final Message inputMessage;
    private boolean allowEmptyDirectory;
    private volatile ZipInputStream zipInputStream;
    private volatile Message parent;

    public ZipIterator(Message inputMessage) {
        this.inputMessage = inputMessage;
        this.allowEmptyDirectory = false;
        InputStream inputStream = (InputStream)inputMessage.getBody(InputStream.class);
        this.zipInputStream = inputStream instanceof ZipInputStream ? (ZipInputStream)inputStream : new ZipInputStream(new BufferedInputStream(inputStream));
        this.parent = null;
    }

    @Override
    public boolean hasNext() {
        try {
            boolean availableDataInCurrentEntry;
            if (this.zipInputStream == null) {
                return false;
            }
            boolean bl = availableDataInCurrentEntry = this.zipInputStream.available() == 1;
            if (!availableDataInCurrentEntry) {
                this.parent = this.getNextElement();
                if (this.parent == null) {
                    this.zipInputStream.close();
                    availableDataInCurrentEntry = false;
                } else {
                    availableDataInCurrentEntry = true;
                }
            }
            return availableDataInCurrentEntry;
        }
        catch (IOException exception) {
            throw new RuntimeCamelException((Throwable)exception);
        }
    }

    @Override
    public Message next() {
        if (this.parent == null) {
            this.parent = this.getNextElement();
        }
        Message answer = this.parent;
        this.parent = null;
        this.checkNullAnswer(answer);
        return answer;
    }

    private Message getNextElement() {
        if (this.zipInputStream == null) {
            return null;
        }
        try {
            ZipEntry current = this.getNextEntry();
            if (current != null) {
                LOGGER.debug("read zipEntry {}", (Object)current.getName());
                DefaultMessage answer = new DefaultMessage();
                answer.getHeaders().putAll(this.inputMessage.getHeaders());
                answer.setHeader("zipFileName", (Object)current.getName());
                answer.setHeader("CamelFileName", (Object)current.getName());
                answer.setBody((Object)new ZipInputStreamWrapper(this.zipInputStream));
                return answer;
            }
            LOGGER.trace("close zipInputStream");
            return null;
        }
        catch (IOException exception) {
            throw new RuntimeCamelException((Throwable)exception);
        }
    }

    public void checkNullAnswer(Message answer) {
        if (answer == null && this.zipInputStream != null) {
            IOHelper.close((Closeable)this.zipInputStream);
            this.zipInputStream = null;
        }
    }

    private ZipEntry getNextEntry() throws IOException {
        ZipEntry entry;
        while ((entry = this.zipInputStream.getNextEntry()) != null) {
            if (!entry.isDirectory()) {
                return entry;
            }
            if (!this.allowEmptyDirectory) continue;
            return entry;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        IOHelper.close((Closeable)this.zipInputStream);
        this.zipInputStream = null;
    }

    public boolean isSupportIteratorForEmptyDirectory() {
        return this.allowEmptyDirectory;
    }

    public void setAllowEmptyDirectory(boolean allowEmptyDirectory) {
        this.allowEmptyDirectory = allowEmptyDirectory;
    }
}

