/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weather;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.weather.WeatherComponent;
import org.apache.camel.component.weather.WeatherConfiguration;
import org.apache.camel.component.weather.WeatherConsumer;
import org.apache.camel.component.weather.WeatherProducer;
import org.apache.camel.impl.DefaultPollingEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(firstVersion="2.12.0", scheme="weather", title="Weather", syntax="weather:name", consumerClass=WeatherConsumer.class, label="api")
public class WeatherEndpoint
extends DefaultPollingEndpoint {
    @UriParam
    private WeatherConfiguration configuration;

    public WeatherEndpoint(String uri, WeatherComponent component, WeatherConfiguration properties) {
        super(uri, (Component)component);
        this.configuration = properties;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        WeatherConsumer answer = new WeatherConsumer(this, processor, this.configuration.getQuery());
        answer.setDelay(3600000L);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Producer createProducer() throws Exception {
        return new WeatherProducer(this, this.configuration.getQuery());
    }

    public boolean isSingleton() {
        return true;
    }

    public WeatherConfiguration getConfiguration() {
        return this.configuration;
    }
}

