/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.swf;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.DynamicWorkflowClientExternal;
import com.amazonaws.services.simpleworkflow.flow.DynamicWorkflowClientExternalImpl;
import com.amazonaws.services.simpleworkflow.flow.StartWorkflowOptions;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericWorkflowClientExternal;
import com.amazonaws.services.simpleworkflow.flow.worker.GenericWorkflowClientExternalImpl;
import com.amazonaws.services.simpleworkflow.model.ChildPolicy;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionDetail;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionInfo;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.aws.swf.SWFConfiguration;
import org.apache.camel.component.aws.swf.SWFEndpoint;

public class CamelSWFWorkflowClient {
    private final SWFEndpoint endpoint;
    private final SWFConfiguration configuration;

    public CamelSWFWorkflowClient(SWFEndpoint endpoint, SWFConfiguration configuration) {
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    public void signalWorkflowExecution(String workflowId, String runId, String signalName, Object arguments) {
        DynamicWorkflowClientExternal dynamicWorkflowClientExternal = this.getDynamicWorkflowClient(workflowId, runId);
        dynamicWorkflowClientExternal.signalWorkflowExecution(signalName, this.toArray(arguments));
    }

    public Object getWorkflowExecutionState(String workflowId, String runId, Class<?> aClass) throws Throwable {
        DynamicWorkflowClientExternal dynamicWorkflowClientExternal = this.getDynamicWorkflowClient(workflowId, runId);
        return dynamicWorkflowClientExternal.getWorkflowExecutionState(aClass);
    }

    public void requestCancelWorkflowExecution(String workflowId, String runId) {
        DynamicWorkflowClientExternal dynamicWorkflowClientExternal = this.getDynamicWorkflowClient(workflowId, runId);
        dynamicWorkflowClientExternal.requestCancelWorkflowExecution();
    }

    public void terminateWorkflowExecution(String workflowId, String runId, String reason, String details, String childPolicy) {
        DynamicWorkflowClientExternal dynamicWorkflowClientExternal = this.getDynamicWorkflowClient(workflowId, runId);
        ChildPolicy policy = childPolicy != null ? ChildPolicy.valueOf((String)childPolicy) : null;
        dynamicWorkflowClientExternal.terminateWorkflowExecution(reason, details, policy);
    }

    public String[] startWorkflowExecution(String workflowId, String runId, String eventName, String version, Object arguments, List<String> tags) {
        DynamicWorkflowClientExternalImpl dynamicWorkflowClientExternal = (DynamicWorkflowClientExternalImpl)this.getDynamicWorkflowClient(workflowId, runId);
        WorkflowType workflowType = new WorkflowType();
        workflowType.setName(eventName);
        workflowType.setVersion(version);
        dynamicWorkflowClientExternal.setWorkflowType(workflowType);
        StartWorkflowOptions startWorkflowOptions = new StartWorkflowOptions();
        startWorkflowOptions.setTaskStartToCloseTimeoutSeconds(Long.valueOf(FlowHelpers.durationToSeconds((String)this.configuration.getTaskStartToCloseTimeout())));
        startWorkflowOptions.setExecutionStartToCloseTimeoutSeconds(Long.valueOf(FlowHelpers.durationToSeconds((String)this.configuration.getExecutionStartToCloseTimeout())));
        startWorkflowOptions.setTagList(tags);
        dynamicWorkflowClientExternal.setSchedulingOptions(startWorkflowOptions);
        dynamicWorkflowClientExternal.startWorkflowExecution(this.toArray(arguments));
        String newWorkflowId = dynamicWorkflowClientExternal.getWorkflowExecution().getWorkflowId();
        String newRunId = dynamicWorkflowClientExternal.getWorkflowExecution().getRunId();
        return new String[]{newWorkflowId, newRunId};
    }

    public Map<String, Object> describeWorkflowInstance(String workflowId, String runId) {
        DescribeWorkflowExecutionRequest describeRequest = new DescribeWorkflowExecutionRequest();
        describeRequest.setDomain(this.configuration.getDomainName());
        describeRequest.setExecution(new WorkflowExecution().withWorkflowId(workflowId).withRunId(runId));
        WorkflowExecutionDetail executionDetail = this.endpoint.getSWClient().describeWorkflowExecution(describeRequest);
        WorkflowExecutionInfo instanceMetadata = executionDetail.getExecutionInfo();
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("closeStatus", instanceMetadata.getCloseStatus());
        info.put("closeTimestamp", instanceMetadata.getCloseTimestamp());
        info.put("executionStatus", instanceMetadata.getExecutionStatus());
        info.put("tagList", instanceMetadata.getTagList());
        info.put("executionDetail", executionDetail);
        return info;
    }

    public List<HistoryEvent> getWorkflowExecutionHistory(String workflowId, String runId) {
        return WorkflowExecutionUtils.getHistory((AmazonSimpleWorkflow)this.endpoint.getSWClient(), (String)this.configuration.getDomainName(), (WorkflowExecution)new WorkflowExecution().withWorkflowId(workflowId).withRunId(runId));
    }

    DynamicWorkflowClientExternal getDynamicWorkflowClient(String workflowId, String runId) {
        GenericWorkflowClientExternalImpl genericClient = new GenericWorkflowClientExternalImpl((AmazonSimpleWorkflow)this.endpoint.getSWClient(), this.configuration.getDomainName());
        WorkflowExecution workflowExecution = new WorkflowExecution();
        workflowExecution.setWorkflowId(workflowId != null ? workflowId : genericClient.generateUniqueId());
        workflowExecution.setRunId(runId);
        return new DynamicWorkflowClientExternalImpl(workflowExecution, null, this.endpoint.getStartWorkflowOptions(), this.configuration.getDataConverter(), (GenericWorkflowClientExternal)genericClient);
    }

    private Object[] toArray(Object input) {
        Object[] inputArray = input instanceof Object[] ? (Object[])input : new Object[]{input};
        return inputArray;
    }
}

