/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.apache.camel.CamelContext;
import org.apache.camel.ComponentVerifier;
import org.apache.camel.Endpoint;
import org.apache.camel.Producer;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.Service;
import org.apache.camel.VerifiableComponent;
import org.apache.camel.component.http4.BasicAuthenticationHttpClientConfigurer;
import org.apache.camel.component.http4.CompositeHttpConfigurer;
import org.apache.camel.component.http4.HttpClientConfigurer;
import org.apache.camel.component.http4.HttpComponentVerifier;
import org.apache.camel.component.http4.HttpEndpoint;
import org.apache.camel.component.http4.ProxyHttpClientConfigurer;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpCommonComponent;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.http.common.HttpRestHeaderFilterStrategy;
import org.apache.camel.http.common.UrlRewrite;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(label="verifiers", enums="parameters,connectivity")
public class HttpComponent
extends HttpCommonComponent
implements RestProducerFactory,
VerifiableComponent,
SSLContextParametersAware {
    private static final Logger LOG = LoggerFactory.getLogger(HttpComponent.class);
    @Metadata(label="advanced", description="To use the custom HttpClientConfigurer to perform configuration of the HttpClient that will be used.")
    protected HttpClientConfigurer httpClientConfigurer;
    @Metadata(label="advanced", description="To use a custom and shared HttpClientConnectionManager to manage connections. If this has been configured then this is always used for all endpoints created by this component.")
    protected HttpClientConnectionManager clientConnectionManager;
    @Metadata(label="advanced", description="To use a custom org.apache.http.protocol.HttpContext when executing requests.")
    protected HttpContext httpContext;
    @Metadata(label="security", description="To configure security using SSLContextParameters. Important: Only one instance of org.apache.camel.util.jsse.SSLContextParameters is supported per HttpComponent. If you need to use 2 or more different instances, you need to define a new HttpComponent per instance you need.")
    protected SSLContextParameters sslContextParameters;
    @Metadata(label="security", description="To use a custom X509HostnameVerifier such as DefaultHostnameVerifier or NoopHostnameVerifier.")
    protected HostnameVerifier x509HostnameVerifier = new DefaultHostnameVerifier();
    @Metadata(label="producer", description="To use a custom org.apache.http.client.CookieStore. By default the org.apache.http.impl.client.BasicCookieStore is used which is an in-memory only cookie store. Notice if bridgeEndpoint=true then the cookie store is forced to be a noop cookie store as cookie shouldn't be stored as we are just bridging (eg acting as a proxy).")
    protected CookieStore cookieStore;
    @Metadata(label="advanced", defaultValue="200", description="The maximum number of connections.")
    protected int maxTotalConnections = 200;
    @Metadata(label="advanced", defaultValue="20", description="The maximum number of connections per route.")
    protected int connectionsPerRoute = 20;
    @Metadata(label="advanced", description="The time for connection to live, the time unit is millisecond, the default value is always keep alive.")
    protected long connectionTimeToLive = -1L;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public HttpComponent() {
        super(HttpEndpoint.class);
    }

    public HttpComponent(Class<? extends HttpEndpoint> endpointClass) {
        super(endpointClass);
    }

    protected HttpClientConfigurer createHttpClientConfigurer(Map<String, Object> parameters, boolean secure) throws Exception {
        HttpClientConfigurer configurer = (HttpClientConfigurer)this.resolveAndRemoveReferenceParameter(parameters, "httpClientConfigurer", HttpClientConfigurer.class);
        if (configurer == null) {
            configurer = this.getHttpClientConfigurer();
        }
        configurer = this.configureBasicAuthentication(parameters, configurer);
        configurer = this.configureHttpProxy(parameters, configurer, secure);
        return configurer;
    }

    private HttpClientConfigurer configureBasicAuthentication(Map<String, Object> parameters, HttpClientConfigurer configurer) {
        String authUsername = (String)this.getParameter(parameters, "authUsername", String.class);
        String authPassword = (String)this.getParameter(parameters, "authPassword", String.class);
        if (authUsername != null && authPassword != null) {
            String authDomain = (String)this.getParameter(parameters, "authDomain", String.class);
            String authHost = (String)this.getParameter(parameters, "authHost", String.class);
            return CompositeHttpConfigurer.combineConfigurers(configurer, new BasicAuthenticationHttpClientConfigurer(authUsername, authPassword, authDomain, authHost));
        }
        return configurer;
    }

    private HttpClientConfigurer configureHttpProxy(Map<String, Object> parameters, HttpClientConfigurer configurer, boolean secure) throws Exception {
        String proxyAuthScheme = (String)this.getParameter(parameters, "proxyAuthScheme", String.class);
        if (proxyAuthScheme == null) {
            proxyAuthScheme = secure ? "https" : "http";
        }
        String proxyAuthHost = (String)this.getParameter(parameters, "proxyAuthHost", String.class);
        Integer proxyAuthPort = (Integer)this.getParameter(parameters, "proxyAuthPort", Integer.class);
        if (proxyAuthHost != null && proxyAuthPort != null) {
            String proxyAuthUsername = (String)this.getParameter(parameters, "proxyAuthUsername", String.class);
            String proxyAuthPassword = (String)this.getParameter(parameters, "proxyAuthPassword", String.class);
            String proxyAuthDomain = (String)this.getParameter(parameters, "proxyAuthDomain", String.class);
            String proxyAuthNtHost = (String)this.getParameter(parameters, "proxyAuthNtHost", String.class);
            if (proxyAuthUsername != null && proxyAuthPassword != null) {
                return CompositeHttpConfigurer.combineConfigurers(configurer, new ProxyHttpClientConfigurer(proxyAuthHost, proxyAuthPort, proxyAuthScheme, proxyAuthUsername, proxyAuthPassword, proxyAuthDomain, proxyAuthNtHost));
            }
            return CompositeHttpConfigurer.combineConfigurers(configurer, new ProxyHttpClientConfigurer(proxyAuthHost, proxyAuthPort, proxyAuthScheme));
        }
        return configurer;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String part;
        HashMap<String, Object> httpClientParameters = new HashMap<String, Object>(parameters);
        HashMap<String, Object> httpClientOptions = new HashMap<String, Object>();
        HttpClientBuilder clientBuilder = this.createHttpClientBuilder(uri, parameters, httpClientOptions);
        HttpBinding httpBinding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBinding", HttpBinding.class);
        HttpContext httpContext = (HttpContext)this.resolveAndRemoveReferenceParameter(parameters, "httpContext", HttpContext.class);
        SSLContextParameters sslContextParameters = (SSLContextParameters)this.resolveAndRemoveReferenceParameter(parameters, "sslContextParameters", SSLContextParameters.class);
        if (sslContextParameters == null) {
            sslContextParameters = this.getSslContextParameters();
        }
        if (sslContextParameters == null) {
            sslContextParameters = this.retrieveGlobalSslContextParameters();
        }
        String httpMethodRestrict = (String)this.getAndRemoveParameter(parameters, "httpMethodRestrict", String.class);
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        UrlRewrite urlRewrite = (UrlRewrite)this.resolveAndRemoveReferenceParameter(parameters, "urlRewrite", UrlRewrite.class);
        boolean secure = HttpHelper.isSecureConnection((String)uri) || sslContextParameters != null;
        String addressUri = (secure ? "https://" : "http://") + remaining;
        addressUri = UnsafeUriCharactersEncoder.encodeHttpURI((String)addressUri);
        URI uriHttpUriAddress = new URI(addressUri);
        int pos = uri.indexOf("//");
        if (pos != -1 && ((part = uri.substring(pos + 2)).startsWith("http:") || part.startsWith("https:"))) {
            throw new ResolveEndpointFailedException(uri, "The uri part is not configured correctly. You have duplicated the http(s) protocol.");
        }
        HttpClientConfigurer configurer = this.createHttpClientConfigurer(parameters, secure);
        URI endpointUri = URISupport.createRemainingURI((URI)uriHttpUriAddress, httpClientParameters);
        String scheme = ObjectHelper.before((String)uri, (String)"://");
        endpointUri = URISupport.createRemainingURI((URI)new URI(scheme, endpointUri.getUserInfo(), endpointUri.getHost(), endpointUri.getPort(), endpointUri.getPath(), endpointUri.getQuery(), endpointUri.getFragment()), httpClientParameters);
        String endpointUriString = endpointUri.toString();
        LOG.debug("Creating endpoint uri {}", (Object)endpointUriString);
        HttpClientConnectionManager localConnectionManager = this.createConnectionManager(parameters, sslContextParameters);
        HttpEndpoint endpoint = new HttpEndpoint(endpointUriString, this, clientBuilder, localConnectionManager, configurer);
        if (this.getHttpConfiguration() != null) {
            HashMap properties = new HashMap();
            IntrospectionSupport.getProperties((Object)this.getHttpConfiguration(), properties, null);
            this.setProperties((Object)endpoint, properties);
        }
        if (urlRewrite != null) {
            this.getCamelContext().addService((Object)urlRewrite);
            endpoint.setUrlRewrite(urlRewrite);
        }
        this.setProperties((Object)endpoint, parameters);
        URI httpUri = URISupport.createRemainingURI((URI)new URI(uriHttpUriAddress.getScheme(), uriHttpUriAddress.getUserInfo(), uriHttpUriAddress.getHost(), uriHttpUriAddress.getPort(), uriHttpUriAddress.getPath(), uriHttpUriAddress.getQuery(), uriHttpUriAddress.getFragment()), parameters);
        endpoint.setHttpUri(httpUri);
        if (headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(headerFilterStrategy);
        } else {
            this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        }
        endpoint.setBinding(this.getHttpBinding());
        if (httpBinding != null) {
            endpoint.setBinding(httpBinding);
        }
        if (httpMethodRestrict != null) {
            endpoint.setHttpMethodRestrict(httpMethodRestrict);
        }
        endpoint.setHttpContext(this.getHttpContext());
        if (httpContext != null) {
            endpoint.setHttpContext(httpContext);
        }
        if (endpoint.getCookieStore() == null) {
            endpoint.setCookieStore(this.getCookieStore());
        }
        endpoint.setHttpClientOptions(httpClientOptions);
        return endpoint;
    }

    protected HttpClientConnectionManager createConnectionManager(Map<String, Object> parameters, SSLContextParameters sslContextParameters) throws GeneralSecurityException, IOException {
        if (this.clientConnectionManager != null) {
            return this.clientConnectionManager;
        }
        HostnameVerifier resolvedHostnameVerifier = (HostnameVerifier)this.resolveAndRemoveReferenceParameter(parameters, "x509HostnameVerifier", HostnameVerifier.class);
        HostnameVerifier hostnameVerifier = Optional.ofNullable(resolvedHostnameVerifier).orElse(this.x509HostnameVerifier);
        int maxTotalConnections = (Integer)this.getAndRemoveParameter(parameters, "maxTotalConnections", Integer.TYPE, 0);
        int connectionsPerRoute = (Integer)this.getAndRemoveParameter(parameters, "connectionsPerRoute", Integer.TYPE, 0);
        Registry<ConnectionSocketFactory> connectionRegistry = this.createConnectionRegistry(hostnameVerifier, sslContextParameters);
        return this.createConnectionManager(connectionRegistry, maxTotalConnections, connectionsPerRoute);
    }

    protected HttpClientBuilder createHttpClientBuilder(String uri, Map<String, Object> parameters, Map<String, Object> httpClientOptions) throws Exception {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        httpClientOptions.putAll(IntrospectionSupport.extractProperties(parameters, (String)"httpClient."));
        IntrospectionSupport.setProperties((Object)clientBuilder, httpClientOptions);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        IntrospectionSupport.setProperties((Object)requestConfigBuilder, httpClientOptions);
        clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        this.validateParameters(uri, httpClientOptions, null);
        return clientBuilder;
    }

    protected Registry<ConnectionSocketFactory> createConnectionRegistry(HostnameVerifier x509HostnameVerifier, SSLContextParameters sslContextParams) throws GeneralSecurityException, IOException {
        RegistryBuilder builder = RegistryBuilder.create();
        builder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        builder.register("http4", (Object)PlainConnectionSocketFactory.getSocketFactory());
        if (sslContextParams != null) {
            builder.register("https", (Object)new SSLConnectionSocketFactory(sslContextParams.createSSLContext(this.getCamelContext()), x509HostnameVerifier));
            builder.register("https4", (Object)new SSLConnectionSocketFactory(sslContextParams.createSSLContext(this.getCamelContext()), x509HostnameVerifier));
        } else {
            builder.register("https4", (Object)new SSLConnectionSocketFactory(SSLContexts.createDefault(), x509HostnameVerifier));
            builder.register("https", (Object)new SSLConnectionSocketFactory(SSLContexts.createDefault(), x509HostnameVerifier));
        }
        return builder.build();
    }

    protected HttpClientConnectionManager createConnectionManager(Registry<ConnectionSocketFactory> registry) {
        return this.createConnectionManager(registry, 0, 0);
    }

    protected HttpClientConnectionManager createConnectionManager(Registry<ConnectionSocketFactory> registry, int maxTotalConnections, int connectionsPerRoute) {
        int localConnectionsPerRoute;
        PoolingHttpClientConnectionManager answer = new PoolingHttpClientConnectionManager(registry, null, null, null, this.getConnectionTimeToLive(), TimeUnit.MILLISECONDS);
        int localMaxTotalConnections = maxTotalConnections;
        if (localMaxTotalConnections == 0) {
            localMaxTotalConnections = this.getMaxTotalConnections();
        }
        if (localMaxTotalConnections > 0) {
            answer.setMaxTotal(localMaxTotalConnections);
        }
        if ((localConnectionsPerRoute = connectionsPerRoute) == 0) {
            localConnectionsPerRoute = this.getConnectionsPerRoute();
        }
        if (localConnectionsPerRoute > 0) {
            answer.setDefaultMaxPerRoute(localConnectionsPerRoute);
        }
        LOG.info("Created ClientConnectionManager " + answer);
        return answer;
    }

    protected boolean useIntrospectionOnEndpoint() {
        return false;
    }

    public Producer createProducer(CamelContext camelContext, String host, String verb, String basePath, String uriTemplate, String queryParameters, String consumes, String produces, Map<String, Object> parameters) throws Exception {
        basePath = FileUtil.stripLeadingSeparator((String)basePath);
        uriTemplate = FileUtil.stripLeadingSeparator((String)uriTemplate);
        String url = host = host.replace("http", "http4");
        if (!ObjectHelper.isEmpty((Object)basePath)) {
            url = url + "/" + basePath;
        }
        if (!ObjectHelper.isEmpty((Object)uriTemplate)) {
            url = url + "/" + uriTemplate;
        }
        HttpEndpoint endpoint = (HttpEndpoint)camelContext.getEndpoint(url, HttpEndpoint.class);
        if (parameters != null && !parameters.isEmpty()) {
            this.setProperties(camelContext, (Object)endpoint, parameters);
        }
        String path = uriTemplate != null ? uriTemplate : basePath;
        endpoint.setHeaderFilterStrategy((HeaderFilterStrategy)new HttpRestHeaderFilterStrategy(path, queryParameters));
        ServiceHelper.startService((Service)endpoint);
        return endpoint.createProducer();
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public HttpClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public void setClientConnectionManager(HttpClientConnectionManager clientConnectionManager) {
        this.clientConnectionManager = clientConnectionManager;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public HostnameVerifier getX509HostnameVerifier() {
        return this.x509HostnameVerifier;
    }

    public void setX509HostnameVerifier(HostnameVerifier x509HostnameVerifier) {
        this.x509HostnameVerifier = x509HostnameVerifier;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getConnectionsPerRoute() {
        return this.connectionsPerRoute;
    }

    public void setConnectionsPerRoute(int connectionsPerRoute) {
        this.connectionsPerRoute = connectionsPerRoute;
    }

    public long getConnectionTimeToLive() {
        return this.connectionTimeToLive;
    }

    public void setConnectionTimeToLive(long connectionTimeToLive) {
        this.connectionTimeToLive = connectionTimeToLive;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public void doStart() throws Exception {
        super.doStart();
    }

    public void doStop() throws Exception {
        if (this.clientConnectionManager != null) {
            LOG.info("Shutting down ClientConnectionManager: " + this.clientConnectionManager);
            this.clientConnectionManager.shutdown();
            this.clientConnectionManager = null;
        }
        super.doStop();
    }

    public ComponentVerifier getVerifier() {
        return new HttpComponentVerifier(this);
    }
}

