/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Producer;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.http4.HttpDeleteWithBodyMethod;
import org.apache.camel.component.http4.HttpEndpoint;
import org.apache.camel.component.http4.HttpMethods;
import org.apache.camel.component.http4.helper.HttpMethodHelper;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.http.common.HttpOperationFailedException;
import org.apache.camel.http.common.HttpProtocolHeaderFilterStrategy;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.GZIPHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(HttpProducer.class);
    private HttpClient httpClient;
    private HttpContext httpContext;
    private boolean throwException;
    private boolean transferException;
    private HeaderFilterStrategy httpProtocolHeaderFilterStrategy = new HttpProtocolHeaderFilterStrategy();

    public HttpProducer(HttpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.httpClient = endpoint.getHttpClient();
        this.httpContext = endpoint.getHttpContext();
        this.throwException = endpoint.isThrowExceptionOnFailure();
        this.transferException = endpoint.isTransferException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        HttpResponse response;
        String hostHeader;
        if (this.getEndpoint().isClearExpiredCookies() && !this.getEndpoint().isBridgeEndpoint()) {
            this.getEndpoint().getCookieStore().clearExpired(new Date());
        }
        Map skipRequestHeaders = null;
        if (this.getEndpoint().isBridgeEndpoint()) {
            exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
            String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
            if (queryString != null) {
                skipRequestHeaders = URISupport.parseQuery((String)queryString, (boolean)false, (boolean)true);
            }
        }
        HttpRequestBase httpRequest = this.createMethod(exchange);
        Message in = exchange.getIn();
        String httpProtocolVersion = (String)in.getHeader("CamelHttpProtocolVersion", String.class);
        if (httpProtocolVersion != null) {
            int[] version = HttpHelper.parserHttpVersion((String)httpProtocolVersion);
            httpRequest.setProtocolVersion((ProtocolVersion)new HttpVersion(version[0], version[1]));
        }
        HeaderFilterStrategy strategy = this.getEndpoint().getHeaderFilterStrategy();
        for (Map.Entry entry : in.getHeaders().entrySet()) {
            String string = (String)entry.getKey();
            Object headerValue = in.getHeader(string);
            if (headerValue == null) continue;
            Iterator it = ObjectHelper.createIterator((Object)headerValue, null, (boolean)true);
            ArrayList<String> values = new ArrayList<String>();
            while (it.hasNext()) {
                String value = (String)exchange.getContext().getTypeConverter().convertTo(String.class, it.next());
                if (skipRequestHeaders != null && skipRequestHeaders.containsKey(string) || value == null || strategy == null || strategy.applyFilterToCamelHeaders(string, (Object)value, exchange)) continue;
                values.add(value);
            }
            if (values.size() <= 0) continue;
            String s = values.size() > 1 ? ((Object)values).toString() : (String)values.get(0);
            httpRequest.addHeader(string, s);
        }
        if (this.getEndpoint().getCookieHandler() != null) {
            Map cookieHeaders = this.getEndpoint().getCookieHandler().loadCookies(exchange, httpRequest.getURI());
            for (Map.Entry throwable : cookieHeaders.entrySet()) {
                String key = (String)throwable.getKey();
                if (((List)throwable.getValue()).size() <= 0) continue;
                String s = ((List)throwable.getValue()).size() > 1 ? ((List)throwable.getValue()).toString() : (String)((List)throwable.getValue()).get(0);
                httpRequest.addHeader(key, s);
            }
        }
        if (this.getEndpoint().isPreserveHostHeader() && (hostHeader = (String)exchange.getIn().getHeader("Host", String.class)) != null) {
            httpRequest.setHeader("Host", hostHeader);
        }
        if (this.getEndpoint().isConnectionClose()) {
            httpRequest.addHeader("Connection", "Close");
        }
        HttpResponse httpResponse = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing http {} method: {}", (Object)httpRequest.getMethod(), (Object)httpRequest.getURI().toString());
            }
            httpResponse = this.executeMethod((HttpUriRequest)httpRequest);
            int responseCode = httpResponse.getStatusLine().getStatusCode();
            LOG.debug("Http responseCode: {}", (Object)responseCode);
            if (!this.throwException) {
                this.populateResponse(exchange, httpRequest, httpResponse, in, strategy, responseCode);
            } else {
                boolean bl = HttpHelper.isStatusCodeOk((int)responseCode, (String)this.getEndpoint().getOkStatusCodeRange());
                if (bl) {
                    this.populateResponse(exchange, httpRequest, httpResponse, in, strategy, responseCode);
                } else {
                    throw this.populateHttpOperationFailedException(exchange, httpRequest, httpResponse, responseCode);
                }
            }
            response = httpResponse;
        }
        catch (Throwable throwable) {
            HttpResponse response2 = httpResponse;
            if (httpResponse != null && this.getEndpoint().isDisableStreamCache()) {
                exchange.addOnCompletion((Synchronization)new SynchronizationAdapter(response2){
                    final /* synthetic */ HttpResponse val$response;
                    {
                        this.val$response = httpResponse;
                    }

                    public void onDone(Exchange exchange) {
                        try {
                            EntityUtils.consume((HttpEntity)this.val$response.getEntity());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            } else if (httpResponse != null) {
                try {
                    EntityUtils.consume((HttpEntity)response2.getEntity());
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        if (httpResponse != null && this.getEndpoint().isDisableStreamCache()) {
            exchange.addOnCompletion((Synchronization)new /* invalid duplicate definition of identical inner class */);
        } else if (httpResponse != null) {
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (Throwable throwable) {}
        }
    }

    public HttpEndpoint getEndpoint() {
        return (HttpEndpoint)super.getEndpoint();
    }

    protected void populateResponse(Exchange exchange, HttpRequestBase httpRequest, HttpResponse httpResponse, Message in, HeaderFilterStrategy strategy, int responseCode) throws IOException, ClassNotFoundException {
        Object response = this.extractResponseBody(httpRequest, httpResponse, exchange, this.getEndpoint().isIgnoreResponseBody());
        Message answer = exchange.getOut();
        answer.setHeader("CamelHttpResponseCode", (Object)responseCode);
        if (httpResponse.getStatusLine() != null) {
            answer.setHeader("CamelHttpResponseText", (Object)httpResponse.getStatusLine().getReasonPhrase());
        }
        answer.setBody(response);
        Header[] headers = httpResponse.getAllHeaders();
        HashMap<String, List<String>> m = new HashMap<String, List<String>>();
        for (Header header : headers) {
            String name = header.getName();
            String value = header.getValue();
            m.put(name, Collections.singletonList(value));
            if (name.toLowerCase().equals("content-type")) {
                name = "Content-Type";
                exchange.setProperty("CamelCharsetName", (Object)IOHelper.getCharsetNameFromContentType((String)value));
            }
            Object extracted = HttpHelper.extractHttpParameterValue((String)value);
            if (strategy == null || strategy.applyFilterToExternalHeaders(name, extracted, exchange)) continue;
            HttpHelper.appendHeader((Map)answer.getHeaders(), (String)name, (Object)extracted);
        }
        if (this.getEndpoint().getCookieHandler() != null) {
            this.getEndpoint().getCookieHandler().storeCookies(exchange, httpRequest.getURI(), m);
        }
        if (this.getEndpoint().isCopyHeaders()) {
            MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)answer, (HeaderFilterStrategy)this.httpProtocolHeaderFilterStrategy, (boolean)false);
        }
    }

    protected Exception populateHttpOperationFailedException(Exchange exchange, HttpRequestBase httpRequest, HttpResponse httpResponse, int responseCode) throws IOException, ClassNotFoundException {
        Header locationHeader;
        String uri = httpRequest.getURI().toString();
        String statusText = httpResponse.getStatusLine() != null ? httpResponse.getStatusLine().getReasonPhrase() : null;
        Map<String, String> headers = HttpProducer.extractResponseHeaders(httpResponse.getAllHeaders());
        if (this.getEndpoint().getCookieHandler() != null) {
            HashMap<String, List<String>> m = new HashMap<String, List<String>>();
            for (Map.Entry<String, String> e : headers.entrySet()) {
                m.put(e.getKey(), Collections.singletonList(e.getValue()));
            }
            this.getEndpoint().getCookieHandler().storeCookies(exchange, httpRequest.getURI(), m);
        }
        Object responseBody = this.extractResponseBody(httpRequest, httpResponse, exchange, this.getEndpoint().isIgnoreResponseBody());
        if (this.transferException && responseBody != null && responseBody instanceof Exception) {
            return (Exception)responseBody;
        }
        String copy = null;
        if (responseBody != null) {
            copy = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, responseBody);
        }
        HttpOperationFailedException answer = (locationHeader = httpResponse.getFirstHeader("location")) != null && responseCode >= 300 && responseCode < 400 ? new HttpOperationFailedException(uri, responseCode, statusText, locationHeader.getValue(), headers, copy) : new HttpOperationFailedException(uri, responseCode, statusText, null, headers, copy);
        return answer;
    }

    protected HttpResponse executeMethod(HttpUriRequest httpRequest) throws IOException {
        BasicHttpContext localContext = new BasicHttpContext();
        if (this.getEndpoint().isAuthenticationPreemptive()) {
            BasicScheme basicAuth = new BasicScheme();
            localContext.setAttribute("preemptive-auth", (Object)basicAuth);
        }
        if (this.httpContext != null) {
            localContext = new BasicHttpContext(this.httpContext);
        }
        return this.httpClient.execute(httpRequest, (HttpContext)localContext);
    }

    protected static Map<String, String> extractResponseHeaders(Header[] responseHeaders) {
        if (responseHeaders == null || responseHeaders.length == 0) {
            return null;
        }
        HashMap<String, String> answer = new HashMap<String, String>();
        for (Header header : responseHeaders) {
            answer.put(header.getName(), header.getValue());
        }
        return answer;
    }

    protected Object extractResponseBody(HttpRequestBase httpRequest, HttpResponse httpResponse, Exchange exchange, boolean ignoreResponseBody) throws IOException, ClassNotFoundException {
        String contentEncoding;
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            return null;
        }
        InputStream is = entity.getContent();
        if (is == null) {
            return null;
        }
        Header header = httpResponse.getFirstHeader("Content-Encoding");
        String string = contentEncoding = header != null ? header.getValue() : null;
        if (!((Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            is = GZIPHelper.uncompressGzip((String)contentEncoding, (InputStream)is);
        }
        String contentType = null;
        header = httpResponse.getFirstHeader("content-type");
        if (header != null) {
            contentType = header.getValue();
            HttpHelper.setCharsetFromContentType((String)contentType, (Exchange)exchange);
        }
        if (contentType != null && contentType.equals("application/x-java-serialized-object")) {
            if (this.getEndpoint().getComponent().isAllowJavaSerializedObject() || this.getEndpoint().isTransferException()) {
                return HttpHelper.deserializeJavaObjectFromStream((InputStream)is, (CamelContext)exchange.getContext());
            }
            return null;
        }
        if (!this.getEndpoint().isDisableStreamCache()) {
            InputStream response = null;
            if (!ignoreResponseBody) {
                response = HttpProducer.doExtractResponseBodyAsStream(is, exchange);
            }
            return response;
        }
        return is;
    }

    private static InputStream doExtractResponseBodyAsStream(InputStream is, Exchange exchange) throws IOException {
        CachedOutputStream cos = null;
        try {
            cos = new CachedOutputStream(exchange, false);
            IOHelper.copy((InputStream)is, (OutputStream)cos);
            InputStream inputStream = cos.getWrappedInputStream();
            return inputStream;
        }
        catch (IOException ex) {
            try {
                cos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        finally {
            IOHelper.close((Closeable)is, (String)"Extracting response body", (Logger)LOG);
        }
    }

    protected HttpRequestBase createMethod(Exchange exchange) throws Exception {
        String url = HttpHelper.createURL((Exchange)exchange, (HttpCommonEndpoint)this.getEndpoint());
        URI uri = HttpHelper.createURI((Exchange)exchange, (String)url, (HttpCommonEndpoint)this.getEndpoint());
        String rewriteUrl = HttpHelper.urlRewrite((Exchange)exchange, (String)(url = uri.toASCIIString()), (HttpCommonEndpoint)this.getEndpoint(), (Producer)this);
        if (rewriteUrl != null) {
            url = rewriteUrl;
            uri = new URI(url);
        }
        HttpEntity requestEntity = this.createRequestEntity(exchange);
        HttpMethods methodToUse = HttpMethodHelper.createMethod(exchange, this.getEndpoint(), requestEntity != null);
        Object method = methodToUse.createMethod(url);
        if (this.getEndpoint().isDeleteWithBody() && "DELETE".equals(method.getMethod())) {
            method = new HttpDeleteWithBodyMethod(url, requestEntity);
        }
        LOG.trace("Using URL: {} with method: {}", (Object)url, method);
        if (methodToUse.isEntityEnclosing()) {
            ((HttpEntityEnclosingRequestBase)method).setEntity(requestEntity);
            if (requestEntity != null && requestEntity.getContentType() == null) {
                LOG.debug("No Content-Type provided for URL: {} with exchange: {}", (Object)url, (Object)exchange);
            }
        }
        if (method.getURI().getScheme() == null || method.getURI().getHost() == null) {
            throw new IllegalArgumentException("Invalid uri: " + uri + ". If you are forwarding/bridging http endpoints, then enable the bridgeEndpoint option on the endpoint: " + (Object)((Object)this.getEndpoint()));
        }
        return method;
    }

    protected HttpEntity createRequestEntity(Exchange exchange) throws CamelExchangeException {
        Message in = exchange.getIn();
        if (in.getBody() == null) {
            return null;
        }
        HttpEntity answer = (HttpEntity)in.getBody(HttpEntity.class);
        if (answer == null) {
            try {
                Object data = in.getBody();
                if (data != null) {
                    ByteArrayEntity entity;
                    String contentTypeString = ExchangeHelper.getContentType((Exchange)exchange);
                    ContentType contentType = null;
                    if (contentTypeString != null) {
                        contentType = contentTypeString.indexOf("charset") > 0 ? ContentType.parse((String)contentTypeString) : ContentType.create((String)contentTypeString);
                    }
                    if (contentTypeString != null && "application/x-java-serialized-object".equals(contentTypeString)) {
                        if (!this.getEndpoint().getComponent().isAllowJavaSerializedObject()) {
                            throw new CamelExchangeException("Content-type application/x-java-serialized-object is not allowed", exchange);
                        }
                        Serializable obj = (Serializable)in.getMandatoryBody(Serializable.class);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        HttpHelper.writeObjectToStream((OutputStream)bos, (Object)obj);
                        entity = new ByteArrayEntity(bos.toByteArray());
                        entity.setContentType("application/x-java-serialized-object");
                        IOHelper.close((Closeable)bos);
                        answer = entity;
                    } else if (data instanceof File || data instanceof GenericFile) {
                        File file = (File)in.getBody(File.class);
                        if (file != null) {
                            answer = contentType != null ? new FileEntity(file, contentType) : new FileEntity(file);
                        }
                    } else if (data instanceof String) {
                        Charset cs;
                        String charset = IOHelper.getCharsetName((Exchange)exchange, (boolean)false);
                        if (charset == null && contentType != null && (cs = contentType.getCharset()) != null) {
                            charset = cs.name();
                        }
                        StringEntity entity2 = new StringEntity((String)data, charset);
                        if (contentType != null) {
                            entity2.setContentType(contentType.toString());
                        }
                        answer = entity2;
                    }
                    if (answer == null) {
                        InputStream is = (InputStream)in.getMandatoryBody(InputStream.class);
                        String length = (String)in.getHeader("Content-Length", String.class);
                        entity = null;
                        entity = ObjectHelper.isEmpty((Object)length) ? new InputStreamEntity(is, -1L) : new InputStreamEntity(is, Long.parseLong(length));
                        if (contentType != null) {
                            entity.setContentType(contentType.toString());
                        }
                        answer = entity;
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new CamelExchangeException("Error creating RequestEntity from message body", exchange, (Throwable)e);
            }
            catch (IOException e) {
                throw new CamelExchangeException("Error serializing message body", exchange, (Throwable)e);
            }
        }
        return answer;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

