/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.cloud;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.component.kubernetes.cloud.KubernetesServiceDiscovery;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;

public class KubernetesDnsServiceDiscovery
extends KubernetesServiceDiscovery {
    private ConcurrentMap<String, List<ServiceDefinition>> cache = new ConcurrentHashMap<String, List<ServiceDefinition>>();

    public KubernetesDnsServiceDiscovery(KubernetesConfiguration configuration) {
        super(configuration);
    }

    public List<ServiceDefinition> getServices(String name) {
        return this.cache.computeIfAbsent(name, key -> Collections.singletonList(this.newService(name)));
    }

    private ServiceDefinition newService(String name) {
        return new DefaultServiceDefinition(name, name + "." + this.getConfiguration().getNamespace() + ".svc." + this.getConfiguration().getDnsDomain(), -1);
    }
}

