/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.producer;

import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildResource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kubernetes.KubernetesEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesBuildsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesBuildsProducer.class);

    public KubernetesBuildsProducer(KubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public KubernetesEndpoint getEndpoint() {
        return (KubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listBuilds": {
                this.doList(exchange, operation);
                break;
            }
            case "listBuildsByLabels": {
                this.doListBuildByLabels(exchange, operation);
                break;
            }
            case "getBuild": {
                this.doGetBuild(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) throws Exception {
        BuildList buildList = (BuildList)((OpenShiftClient)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class)).builds().list();
        exchange.getOut().setBody((Object)buildList.getItems());
    }

    protected void doListBuildByLabels(Exchange exchange, String operation) throws Exception {
        BuildList buildList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesBuildsLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (!ObjectHelper.isEmpty((Object)namespaceName)) {
            NonNamespaceOperation builds = (NonNamespaceOperation)((OpenShiftClient)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class)).builds().inNamespace(namespaceName);
            for (Map.Entry entry : labels.entrySet()) {
                builds.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            buildList = (BuildList)builds.list();
        } else {
            MixedOperation builds = ((OpenShiftClient)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class)).builds();
            for (Map.Entry entry : labels.entrySet()) {
                builds.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            buildList = (BuildList)builds.list();
        }
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)buildList.getItems());
    }

    protected void doGetBuild(Exchange exchange, String operation) throws Exception {
        Build build = null;
        String buildName = (String)exchange.getIn().getHeader("CamelKubernetesBuildName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)buildName)) {
            LOG.error("Get a specific Build require specify a Build name");
            throw new IllegalArgumentException("Get a specific Build require specify a Build name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Get a specific Build require specify a namespace name");
            throw new IllegalArgumentException("Get a specific Build require specify a namespace name");
        }
        build = (Build)((BuildResource)((NonNamespaceOperation)((OpenShiftClient)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class)).builds().inNamespace(namespaceName)).withName(buildName)).get();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)build);
    }
}

