/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.producer;

import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kubernetes.KubernetesEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesServiceAccountsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesServiceAccountsProducer.class);

    public KubernetesServiceAccountsProducer(KubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public KubernetesEndpoint getEndpoint() {
        return (KubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listServiceAccounts": {
                this.doList(exchange, operation);
                break;
            }
            case "listServiceAccountsByLabels": {
                this.doListServiceAccountsByLabels(exchange, operation);
                break;
            }
            case "getSecret": {
                this.doGetServiceAccount(exchange, operation);
                break;
            }
            case "createServiceAccount": {
                this.doCreateServiceAccount(exchange, operation);
                break;
            }
            case "deleteServiceAccount": {
                this.doDeleteServiceAccount(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) throws Exception {
        ServiceAccountList saList = (ServiceAccountList)this.getEndpoint().getKubernetesClient().serviceAccounts().list();
        exchange.getOut().setBody((Object)saList.getItems());
    }

    protected void doListServiceAccountsByLabels(Exchange exchange, String operation) throws Exception {
        ServiceAccountList saList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesServiceAccountsLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (!ObjectHelper.isEmpty((Object)namespaceName)) {
            NonNamespaceOperation serviceAccounts = (NonNamespaceOperation)this.getEndpoint().getKubernetesClient().serviceAccounts().inNamespace(namespaceName);
            for (Map.Entry entry : labels.entrySet()) {
                serviceAccounts.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            saList = (ServiceAccountList)serviceAccounts.list();
        } else {
            MixedOperation serviceAccounts = this.getEndpoint().getKubernetesClient().serviceAccounts();
            for (Map.Entry entry : labels.entrySet()) {
                serviceAccounts.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            saList = (ServiceAccountList)serviceAccounts.list();
        }
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)saList.getItems());
    }

    protected void doGetServiceAccount(Exchange exchange, String operation) throws Exception {
        ServiceAccount sa = null;
        String saName = (String)exchange.getIn().getHeader("CamelKubernetesServiceAccountName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)saName)) {
            LOG.error("Get a specific Service Account require specify a Service Account name");
            throw new IllegalArgumentException("Get a specific Service Account require specify a Service Account name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Get a specific Service Account require specify a namespace name");
            throw new IllegalArgumentException("Get a specific Service Account require specify a namespace name");
        }
        sa = (ServiceAccount)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().serviceAccounts().inNamespace(namespaceName)).withName(saName)).get();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)sa);
    }

    protected void doCreateServiceAccount(Exchange exchange, String operation) throws Exception {
        ServiceAccount sa = null;
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        ServiceAccount saToCreate = (ServiceAccount)exchange.getIn().getHeader("CamelKubernetesServiceAccount", ServiceAccount.class);
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Create a specific Service Account require specify a namespace name");
            throw new IllegalArgumentException("Create a specific Service Account require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)saToCreate)) {
            LOG.error("Create a specific Service Account require specify a Service Account bean");
            throw new IllegalArgumentException("Create a specific Service Account require specify a Service Account bean");
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesServiceAccountsLabels", Map.class);
        sa = (ServiceAccount)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().serviceAccounts().inNamespace(namespaceName)).create((Object[])new ServiceAccount[]{saToCreate});
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)sa);
    }

    protected void doDeleteServiceAccount(Exchange exchange, String operation) throws Exception {
        String saName = (String)exchange.getIn().getHeader("CamelKubernetesServiceAccountName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)saName)) {
            LOG.error("Delete a specific Service Account require specify a Service Account name");
            throw new IllegalArgumentException("Delete a specific Service Account require specify a Service Account name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Delete a specific Service Account require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific Service Account require specify a namespace name");
        }
        boolean saDeleted = (Boolean)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().serviceAccounts().inNamespace(namespaceName)).withName(saName)).delete();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)saDeleted);
    }
}

